/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.compat.jei.validator;

import com.mrbysco.spoiled.Constants;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;

public class SpoiledValidator {
    private static final int INVALID_COUNT = -1;
    private final IRecipeCategory<SpoilRecipe> recipeCategory;

    public SpoiledValidator(IRecipeCategory<SpoilRecipe> recipeCategory) {
        this.recipeCategory = recipeCategory;
    }

    public boolean isRecipeValid(RecipeHolder<SpoilRecipe> recipe) {
        return this.hasValidInputsAndOutputs(recipe);
    }

    public boolean isRecipeHandled(RecipeHolder<SpoilRecipe> recipe) {
        return this.recipeCategory.isHandled((Object)((SpoilRecipe)recipe.value()));
    }

    private boolean hasValidInputsAndOutputs(RecipeHolder<SpoilRecipe> recipeHolder) {
        if (recipeHolder == null) {
            return false;
        }
        SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
        if (recipe.isSpecial()) {
            return true;
        }
        ItemStack recipeOutput = recipe.getResultItem(null);
        if (recipeOutput == null || recipeOutput.isEmpty()) {
            Constants.LOGGER.error("Recipe has no output. {}", (Object)recipeHolder.id());
            return false;
        }
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        if (ingredients == null) {
            Constants.LOGGER.error("Recipe has no input Ingredients. {}", (Object)recipeHolder.id());
            return false;
        }
        int inputCount = SpoiledValidator.getInputCount(ingredients);
        if (inputCount == -1) {
            return false;
        }
        if (inputCount > 1) {
            Constants.LOGGER.error("Recipe has too many inputs. {}", (Object)recipeHolder.id());
            return false;
        }
        if (inputCount == 0) {
            Constants.LOGGER.error("Recipe has no inputs. {}", (Object)recipeHolder.id());
            return false;
        }
        return true;
    }

    private static int getInputCount(List<Ingredient> ingredientList) {
        int inputCount = 0;
        for (Ingredient ingredient : ingredientList) {
            ItemStack[] input = ingredient.getItems();
            if (input == null) {
                return -1;
            }
            ++inputCount;
        }
        return inputCount;
    }
}

