/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.compat.rei;

import com.mrbysco.spoiled.compat.rei.category.SpoilCategoryNeoForge;
import com.mrbysco.spoiled.compat.rei.display.SpoilDisplayNeoForge;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.registration.SpoiledRecipes;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@REIPluginClient
public class REIPluginNeoForge
implements REIClientPlugin {
    public static final CategoryIdentifier<SpoilDisplayNeoForge> SPOILING = CategoryIdentifier.of((String)"spoiled", (String)"plugins/spoiling");

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new SpoilCategoryNeoForge());
        registry.addWorkstations(SPOILING, new EntryStack[]{EntryStacks.of((ItemLike)Items.ROTTEN_FLESH)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        List spoilHolders = registry.getRecipeManager().getAllRecipesFor(SpoiledRecipes.SPOIL_RECIPE_TYPE.get());
        spoilHolders.forEach(holder -> {
            SpoilRecipe recipe = (SpoilRecipe)holder.value();
            registry.add((Display)new SpoilDisplayNeoForge((Ingredient)recipe.getIngredients().get(0), recipe.getResultItem((HolderLookup.Provider)registryAccess)));
        });
    }
}

