/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.config;

import com.mrbysco.spoiled.Constants;
import com.mrbysco.spoiled.config.SpoiledConfigCache;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SpoiledConfig {
    public static final List<String> DEFAULT_SPOIL_BLACKLIST = List.of("minecraft:rotten_flesh", "minecraft:enchanted_golden_apple");
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ModConfigSpec serverSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        Constants.LOGGER.debug("Loaded Spoiled's config file {}", (Object)config.getFileName());
        SpoiledConfig.refreshCache(config.getType());
    }

    private static void refreshCache(ModConfig.Type type) {
        if (type == ModConfig.Type.COMMON) {
            SpoiledConfigCache.setSpoilRate((Integer)SpoiledConfig.COMMON.spoilRate.get());
            SpoiledConfigCache.generateContainerModifier((List)SpoiledConfig.COMMON.containerModifier.get());
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<List<? extends String>> containerModifier;
        public final ModConfigSpec.IntValue spoilRate;
        public final ModConfigSpec.BooleanValue initializeSpoiling;
        public final ModConfigSpec.BooleanValue mergeSpoilingFood;
        public final ModConfigSpec.BooleanValue spoilEverything;
        public final ModConfigSpec.ConfigValue<List<? extends String>> spoilBlacklist;
        public final ModConfigSpec.IntValue defaultSpoilTime;
        public final ModConfigSpec.ConfigValue<String> defaultSpoilItem;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            String[] containers = new String[]{"minecraft:shulker_box,0"};
            this.containerModifier = builder.comment("Determines the spoilrate in specific containers [Syntax: tileentity:spoil_rate]\nExamples: \"minecraft:shulker_box,0\" would make shulker boxes not spoil food\n\"cookingforblockheads:fridge,0.2\" would make a cooking for blockheads fridge spoil at 20% of the usual spoilrate").defineListAllowEmpty(List.of("containerModifier"), () -> List.of(containers), o -> o instanceof String);
            this.spoilRate = builder.comment("Defines the default total amount of spoiling updates for each food item \n(For example, a defaultSpoilTime of 40 means any default food item will have 40 total updates before it spoils. \nThis can be altered when custom food spoiling is set using a datapack) [default: 30]").defineInRange("spoilRate", 30, 1, Integer.MAX_VALUE);
            this.initializeSpoiling = builder.comment("When enabled Spoiled initializes spoiling for all vanilla food [default: true]").define("initializeSpoiling", true);
            this.mergeSpoilingFood = builder.comment("When enabled enables a special recipe to merge spoiling food together [default: false]").define("mergeSpoilingFood", false);
            this.spoilEverything = builder.comment("When enabled Spoiled makes every edible item spoil into the specified Spoil Item (This overwrites json spoiling completely) [default: false]").define("spoilEverything", false);
            this.spoilBlacklist = builder.comment("Defines a list of items that are never allowed to spoil").defineListAllowEmpty(List.of("spoilBlacklist"), () -> DEFAULT_SPOIL_BLACKLIST, o -> o instanceof String);
            this.defaultSpoilTime = builder.comment("Defines the total amount of spoiling updates that is used by the default initialized spoiling when 'initializeSpoiling' is enabled \n(If the 'spoilRate' is 10 and the 'defaultSpoilTime' is set to 20 then the food will spoil after 20 * 10 seconds = 200 seconds) [default: 40]").defineInRange("defaultSpoilTime", 40, 1, Integer.MAX_VALUE);
            this.defaultSpoilItem = builder.comment("Defines the item the foods vanilla foods will turn into when spoiled (if empty it will clear the spoiling item) [default: 'minecraft:rotten_flesh']").define("defaultSpoilItem", (Object)"minecraft:rotten_flesh");
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue showPercentage;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.showPercentage = builder.comment("When enabled makes the food's tooltips show percentages").define("showPercentage", false);
            builder.pop();
        }
    }
}

