/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.config;

import com.mrbysco.spoiled.Constants;
import com.mrbysco.spoiled.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.math.NumberUtils;

public class SpoiledConfigCache {
    public static Map<ResourceLocation, Double> containerModifier;
    public static long spoilRate;

    public static void setSpoilRate(int value) {
        spoilRate = (long)value * 20L;
    }

    public static ItemStack getDefaultSpoilItem() {
        String value = Services.PLATFORM.getDefaultSpoilItem();
        if (value.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)value));
        if (item != null) {
            return new ItemStack((ItemLike)item);
        }
        Constants.LOGGER.error("'defaultSpoilItem' couldn't be parsed, using default");
        return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)"rotten_flesh")));
    }

    public static void generateContainerModifier(List<? extends String> configValues) {
        HashMap<ResourceLocation, Double> modifierMap = new HashMap<ResourceLocation, Double>();
        if (!configValues.isEmpty()) {
            for (String string : configValues) {
                if (!string.contains(",")) {
                    if (string.contains(":")) {
                        Constants.LOGGER.error(String.format("Invalid syntax '%s' found in 'containerModifier' config values, supplying default modifier of 0", string));
                        modifierMap.put(ResourceLocation.tryParse((String)string), 0.0);
                        continue;
                    }
                    Constants.LOGGER.error(String.format("Invalid syntax '%s' found in 'containerModifier' config values", string));
                    continue;
                }
                String[] values = string.split(",");
                if (values.length == 2) {
                    if (!values[0].contains(":")) {
                        Constants.LOGGER.error(String.format("Invalid resourcelocation syntax in 'containerModifier'. could not find \":\" in %s", string));
                        return;
                    }
                    ResourceLocation registry = ResourceLocation.tryParse((String)values[0]);
                    double modifier = NumberUtils.isParsable((String)values[1]) ? Double.parseDouble(values[1]) : -1.0;
                    modifierMap.put(registry, modifier);
                    continue;
                }
                Constants.LOGGER.error(String.format("Tried looking for 2 values in 'containerModifier' but found more making the config value %s invalid", string));
            }
        }
        containerModifier = modifierMap;
    }
}

