/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.datagen;

import com.mrbysco.spoiled.datagen.client.SpoiledLanguageProvider;
import com.mrbysco.spoiled.datagen.server.SpoiledItemTagProvider;
import com.mrbysco.spoiled.datagen.server.SpoiledRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SpoiledDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new SpoiledRecipeProvider(packOutput, lookupProvider));
            BlockTagsProvider blockTagsProvider = new BlockTagsProvider(packOutput, lookupProvider, "spoiled", helper){

                protected void addTags(HolderLookup.Provider provider) {
                }
            };
            generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
            generator.addProvider(event.includeServer(), (DataProvider)new SpoiledItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), helper));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeServer(), (DataProvider)new SpoiledLanguageProvider(packOutput));
        }
    }
}

