/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.datagen.server;

import com.mrbysco.spoiled.Constants;
import com.mrbysco.spoiled.datagen.SpoilRecipeBuilder;
import com.mrbysco.spoiled.recipe.StackFoodRecipe;
import com.mrbysco.spoiled.recipe.condition.InitializeSpoilingCondition;
import com.mrbysco.spoiled.recipe.condition.MergeRecipeCondition;
import com.mrbysco.spoiled.util.SpoiledTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public class SpoiledRecipeProvider
extends RecipeProvider {
    public SpoiledRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        String toRotten = "_to_rotten_flesh";
        String folder = "spoiling/";
        RecipeOutput initializeOutput = recipeOutput.withConditions(new ICondition[]{InitializeSpoilingCondition.INSTANCE});
        SpoilRecipeBuilder.spoilRecipe(Ingredient.of(SpoiledTags.FOODS), (ItemLike)Items.ROTTEN_FLESH).build(initializeOutput, Constants.modLoc(folder + "initial" + toRotten));
        RecipeOutput mergeOutput = recipeOutput.withConditions(new ICondition[]{MergeRecipeCondition.INSTANCE});
        SpecialRecipeBuilder.special(StackFoodRecipe::new).save(mergeOutput, Constants.modLoc("merge_food"));
    }
}

