/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.handler;

import com.google.common.collect.Lists;
import com.mrbysco.spoiled.config.SpoiledConfigCache;
import com.mrbysco.spoiled.mixin.RandomizableContainerBlockEntityAccessor;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.util.ChunkHelper;
import com.mrbysco.spoiled.util.SpoilHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class SpoilHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldTick(LevelTickEvent.Post event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).getGameTime() % SpoiledConfigCache.spoilRate == 0L) {
            if (level.dimension() != Level.OVERWORLD) {
                return;
            }
            List<BlockPos> blockEntityPositions = ChunkHelper.getBlockEntityPositions((Level)level).stream().filter(pos -> level.isAreaLoaded(pos, 1)).toList();
            if (!blockEntityPositions.isEmpty()) {
                for (BlockPos pos2 : blockEntityPositions) {
                    IItemHandler itemHandler;
                    boolean spoilFlag;
                    RandomizableContainerBlockEntity randomizeInventory;
                    BlockEntity be = level.getBlockEntity(pos2);
                    if (be == null || be.isRemoved() || !be.hasLevel() || be instanceof RandomizableContainerBlockEntity && ((RandomizableContainerBlockEntityAccessor)(randomizeInventory = (RandomizableContainerBlockEntity)be)).getLootTable() != null) continue;
                    ResourceLocation location = BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)be.getType());
                    double spoilRate = 1.0;
                    if (location != null && SpoiledConfigCache.containerModifier.containsKey(location)) {
                        spoilRate = SpoiledConfigCache.containerModifier.get(location);
                    }
                    if (!(spoilFlag = spoilRate == 1.0 || spoilRate > 0.0 && level.random.nextDouble() <= spoilRate) || (itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos2, null)) == null || itemHandler.getSlots() <= 0) continue;
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        if (stack == null || stack.isEmpty()) continue;
                        int slot = i;
                        RecipeHolder<SpoilRecipe> recipeHolder = SpoilHelper.getSpoilRecipe((Level)level, stack);
                        if (recipeHolder == null) continue;
                        SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
                        SpoilHelper.updateSpoilingStack(stack, recipe);
                        if (!SpoilHelper.isSpoiled(stack)) continue;
                        SpoilHandler.spoilItemInHandler(itemHandler, slot, stack, recipe, level.registryAccess());
                    }
                }
            }
            ArrayList entityList = Lists.newArrayList();
            level.getAllEntities().forEach(entityList::add);
            List<Entity> containerEntities = entityList.stream().filter(e -> e instanceof Container && e.isAlive()).toList();
            for (Entity entity : containerEntities) {
                this.updateContainer((Level)level, entity, (Container)entity);
            }
        }
    }

    public static void spoilItemInHandler(IItemHandler itemHandler, int slot, ItemStack stack, SpoilRecipe recipe, RegistryAccess registryAccess) {
        ItemStack spoiledStack = recipe.getResultItem((HolderLookup.Provider)registryAccess).copy();
        int oldStackCount = stack.getCount();
        stack.setCount(0);
        if (!spoiledStack.isEmpty()) {
            spoiledStack.setCount(oldStackCount);
            itemHandler.insertItem(slot, spoiledStack, false);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).level().getGameTime() % SpoiledConfigCache.spoilRate == 0L && !player.getAbilities().instabuild) {
            this.updateInventory((Player)player);
        }
    }

    private void updateInventory(Player player) {
        Level level = player.level();
        int invCount = player.getInventory().getContainerSize();
        for (int i = 0; i < invCount; ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            IItemHandler itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            if (itemHandler != null && itemHandler.getSlots() > 0) {
                for (int j = 0; j < itemHandler.getSlots(); ++j) {
                    RecipeHolder<SpoilRecipe> recipeHolder;
                    ItemStack nestedStack = itemHandler.getStackInSlot(j);
                    if (nestedStack == null || nestedStack.isEmpty() || (recipeHolder = SpoilHelper.getSpoilRecipe(level, nestedStack)) == null) continue;
                    SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
                    SpoilHelper.updateSpoilingStack(nestedStack, recipe);
                    if (!SpoilHelper.isSpoiled(nestedStack)) continue;
                    SpoilHandler.spoilItemInHandler(itemHandler, j, nestedStack, recipe, level.registryAccess());
                }
                continue;
            }
            RecipeHolder<SpoilRecipe> recipeHolder = SpoilHelper.getSpoilRecipe(level, stack);
            if (recipeHolder == null) continue;
            SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
            SpoilHelper.updateSpoilingStack(stack, recipe);
            if (!SpoilHelper.isSpoiled(stack)) continue;
            SpoilHelper.spoilItemForPlayer(player, stack, recipe);
        }
    }

    private void updateContainer(Level level, Entity entity, Container container) {
        int invCount = container.getContainerSize();
        for (int i = 0; i < invCount; ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty()) continue;
            IItemHandler itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            if (itemHandler != null && itemHandler.getSlots() > 0) {
                for (int j = 0; j < itemHandler.getSlots(); ++j) {
                    RecipeHolder<SpoilRecipe> recipeHolder;
                    ItemStack nestedStack = itemHandler.getStackInSlot(j);
                    if (nestedStack == null || nestedStack.isEmpty() || (recipeHolder = SpoilHelper.getSpoilRecipe(level, nestedStack)) == null) continue;
                    SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
                    SpoilHelper.updateSpoilingStack(nestedStack, recipe);
                    if (!SpoilHelper.isSpoiled(nestedStack)) continue;
                    SpoilHandler.spoilItemInHandler(itemHandler, j, nestedStack, recipe, level.registryAccess());
                }
                continue;
            }
            RecipeHolder<SpoilRecipe> recipeHolder = SpoilHelper.getSpoilRecipe(level, stack);
            if (recipeHolder == null) continue;
            SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
            SpoilHelper.updateSpoilingStack(stack, recipe);
            if (!SpoilHelper.isSpoiled(stack)) continue;
            SpoilHelper.spoilItemForEntity(container, entity, stack, recipe);
        }
    }
}

