/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrbysco.spoiled.platform.Services;
import com.mrbysco.spoiled.registration.SpoiledRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class SpoilRecipe
implements Recipe<SingleRecipeInput> {
    protected final String group;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int spoilTime;

    public SpoilRecipe(String group, Ingredient ingredient, ItemStack stack, int spoilTime) {
        this.group = group;
        this.ingredient = ingredient;
        this.result = stack;
        this.spoilTime = spoilTime;
    }

    public RecipeType<?> getType() {
        return SpoiledRecipes.SPOIL_RECIPE_TYPE.get();
    }

    public boolean matches(SingleRecipeInput recipeInput, Level level) {
        return ((Ingredient)this.getIngredients().get(0)).test(recipeInput.getItem(0));
    }

    public ItemStack assemble(SingleRecipeInput recipeInput, HolderLookup.Provider registryAccess) {
        return this.getResultItem(registryAccess).copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return false;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.result.copy();
    }

    public String getGroup() {
        return this.group;
    }

    public int getSpoilTime() {
        if (this.spoilTime == -1) {
            return Services.PLATFORM.getDefaultSpoilTime();
        }
        return this.spoilTime;
    }

    public RecipeSerializer<?> getSerializer() {
        return SpoiledRecipes.SPOILING_SERIALIZER.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SpoilRecipe> {
        public static final MapCodec<SpoilRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.optionalFieldOf("spoiltime", (Object)-1).forGetter(recipe -> recipe.spoilTime)).apply((Applicative)instance, SpoilRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SpoilRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SpoilRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SpoilRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static SpoilRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf(Short.MAX_VALUE);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            int spoilTime = buffer.readVarInt();
            return new SpoilRecipe(s, ingredient, itemstack, spoilTime);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, SpoilRecipe recipe) {
            buffer.writeUtf(recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeVarInt(recipe.spoilTime);
        }
    }
}

