/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.recipe;

import com.google.common.collect.Lists;
import com.mrbysco.spoiled.registration.SpoiledRecipes;
import com.mrbysco.spoiled.util.SpoilHelper;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class StackFoodRecipe
extends CustomRecipe {
    public StackFoodRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemstack = craftingInput.getItem(i);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
            if (list.size() <= 1) continue;
            ItemStack stack1 = (ItemStack)list.get(0);
            if (itemstack.getItem() == stack1.getItem() && SpoilHelper.totalUnderMax(itemstack, stack1) && SpoilHelper.isSpoiling(stack1)) continue;
            return false;
        }
        return list.size() == 2;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider registryAccess) {
        ItemStack stack2;
        ItemStack stack1;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack itemstack = craftingInput.getItem(i);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
            if (list.size() <= 1) continue;
            ItemStack stack12 = (ItemStack)list.get(0);
            if (itemstack.getItem() == stack12.getItem() && SpoilHelper.isSpoiling(stack12)) continue;
            return ItemStack.EMPTY;
        }
        if (list.size() == 2 && ItemStack.isSameItem((ItemStack)(stack1 = (ItemStack)list.get(0)), (ItemStack)(stack2 = (ItemStack)list.get(1))) && SpoilHelper.isSpoiling(stack1) && SpoilHelper.totalUnderMax(stack1, stack2)) {
            int spoil1 = SpoilHelper.getSpoilTime(stack1);
            int spoil2 = SpoilHelper.getSpoilTime(stack2);
            int averageSpoil = (int)((double)(spoil1 + spoil2) / 2.0);
            ItemStack stackCopy = stack1.copy();
            int combinedCount = stack1.getCount() + stack2.getCount();
            stackCopy.setCount(combinedCount);
            SpoilHelper.setSpoilTime(stackCopy, averageSpoil);
            return stackCopy;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput craftingInput) {
        NonNullList nonnulllist = super.getRemainingItems((RecipeInput)craftingInput);
        for (int i = 0; i < craftingInput.size(); ++i) {
            nonnulllist.set(i, (Object)ItemStack.EMPTY);
        }
        return nonnulllist;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SpoiledRecipes.STACK_FOOD_SERIALIZER.get();
    }
}

