/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.util;

import com.mrbysco.spoiled.Constants;
import com.mrbysco.spoiled.component.SpoilTimer;
import com.mrbysco.spoiled.config.SpoiledConfigCache;
import com.mrbysco.spoiled.platform.Services;
import com.mrbysco.spoiled.recipe.SpoilRecipe;
import com.mrbysco.spoiled.registration.SpoiledComponents;
import com.mrbysco.spoiled.registration.SpoiledRecipes;
import com.mrbysco.spoiled.util.SpoiledTags;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class SpoilHelper {
    public static RecipeHolder<SpoilRecipe> getSpoilRecipe(Level level, ItemStack stack) {
        String itemPath = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        List<String> spoilBlacklist = Services.PLATFORM.getSpoilBlacklist();
        if (!spoilBlacklist.isEmpty() && spoilBlacklist.contains(itemPath)) {
            return null;
        }
        if (Services.PLATFORM.spoilEverything()) {
            ResourceLocation stackLocation = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (stack.has(DataComponents.FOOD)) {
                ItemStack spoilStack = SpoiledConfigCache.getDefaultSpoilItem();
                String result = spoilStack.isEmpty() ? "to_air" : "to_" + BuiltInRegistries.ITEM.getKey((Object)spoilStack.getItem()).getPath();
                String recipePath = "everything_" + stackLocation.getPath() + result;
                return new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)"spoiled", (String)recipePath), (Recipe)new SpoilRecipe("", Ingredient.of((ItemStack[])new ItemStack[]{stack}), spoilStack, Services.PLATFORM.getDefaultSpoilTime()));
            }
        } else {
            if (stack.is(SpoiledTags.FOODS_BLACKLIST)) {
                return null;
            }
            return level.getRecipeManager().getRecipeFor(SpoiledRecipes.SPOIL_RECIPE_TYPE.get(), (RecipeInput)new SingleRecipeInput(stack), level).orElse(null);
        }
        return null;
    }

    public static boolean isSpoiling(ItemStack stack) {
        return stack.has(SpoiledComponents.SPOIL_TIMER.get());
    }

    public static int getSpoilTime(ItemStack stack) {
        return stack.has(SpoiledComponents.SPOIL_TIMER.get()) ? ((SpoilTimer)stack.get(SpoiledComponents.SPOIL_TIMER.get())).timer() : 0;
    }

    public static void setSpoilTime(ItemStack stack, int time) {
        if (stack.has(SpoiledComponents.SPOIL_TIMER.get())) {
            SpoilTimer spoilTimer = (SpoilTimer)stack.get(SpoiledComponents.SPOIL_TIMER.get());
            stack.set(SpoiledComponents.SPOIL_TIMER.get(), (Object)new SpoilTimer(time, spoilTimer.maxTime()));
        } else {
            Constants.LOGGER.info("Tried to set spoil time for a stack without spoil timer component");
        }
    }

    public static void spoilItemForPlayer(Player player, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.getResultItem((HolderLookup.Provider)player.level().registryAccess()).copy();
        int oldStackCount = stack.getCount();
        stack.shrink(Integer.MAX_VALUE);
        if (!spoiledStack.isEmpty()) {
            spoiledStack.setCount(oldStackCount);
            if (!player.addItem(spoiledStack)) {
                ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), spoiledStack);
                player.level().addFreshEntity((Entity)itemEntity);
            }
        }
    }

    public static void spoilItemForEntity(Container container, Entity entity, ItemStack stack, SpoilRecipe recipe) {
        ItemStack spoiledStack = recipe.getResultItem((HolderLookup.Provider)entity.level().registryAccess()).copy();
        int oldStackCount = stack.getCount();
        stack.shrink(Integer.MAX_VALUE);
        if (!spoiledStack.isEmpty()) {
            spoiledStack.setCount(oldStackCount);
            int freeSlot = SpoilHelper.getFreeSlot(container);
            if (freeSlot != -1) {
                container.setItem(freeSlot, spoiledStack);
            } else {
                ItemEntity itemEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), spoiledStack);
                entity.level().addFreshEntity((Entity)itemEntity);
            }
        }
    }

    public static void spoilSingleItemAndReplace(Level level, ItemStack stack, Consumer<ItemStack> setCallback) {
        RecipeHolder<SpoilRecipe> recipeHolder;
        if (level.getGameTime() % SpoiledConfigCache.spoilRate == 0L && stack.getCount() == 1 && (recipeHolder = SpoilHelper.getSpoilRecipe(level, stack)) != null) {
            SpoilRecipe recipe = (SpoilRecipe)recipeHolder.value();
            SpoilHelper.updateSpoilingStack(stack, recipe);
            if (SpoilHelper.isSpoiled(stack)) {
                ItemStack spoiledStack = recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                int oldStackCount = stack.getCount();
                stack.shrink(Integer.MAX_VALUE);
                if (!spoiledStack.isEmpty()) {
                    spoiledStack.setCount(oldStackCount);
                    setCallback.accept(spoiledStack);
                }
            }
        }
    }

    private static int getFreeSlot(Container container) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            if (!container.getItem(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static void updateSpoilingStack(ItemStack stack, SpoilRecipe recipe) {
        if (stack.has(SpoiledComponents.SPOIL_TIMER.get())) {
            SpoilTimer spoilTimer = (SpoilTimer)stack.get(SpoiledComponents.SPOIL_TIMER.get());
            if (spoilTimer != null) {
                int getOldTime = spoilTimer.timer();
                int getMaxTime = spoilTimer.maxTime();
                if (getMaxTime != recipe.getSpoilTime()) {
                    getMaxTime = recipe.getSpoilTime();
                }
                if (getOldTime < getMaxTime) {
                    spoilTimer = new SpoilTimer(++getOldTime, getMaxTime);
                    stack.set(SpoiledComponents.SPOIL_TIMER.get(), (Object)spoilTimer);
                }
            }
        } else {
            stack.set(SpoiledComponents.SPOIL_TIMER.get(), (Object)new SpoilTimer(recipe.getSpoilTime()));
        }
    }

    public static boolean isSpoiled(ItemStack stack) {
        SpoilTimer spoilTimer;
        if (stack.has(SpoiledComponents.SPOIL_TIMER.get()) && (spoilTimer = (SpoilTimer)stack.get(SpoiledComponents.SPOIL_TIMER.get())) != null) {
            int getMaxTime;
            int getOldTime = spoilTimer.timer();
            return getOldTime >= (getMaxTime = spoilTimer.maxTime());
        }
        return false;
    }

    public static boolean totalUnderMax(ItemStack stack1, ItemStack stack2) {
        return stack1.getCount() + stack2.getCount() <= stack1.getMaxStackSize();
    }
}

