/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.spoiled.util;

import com.mrbysco.spoiled.component.SpoilTimer;
import com.mrbysco.spoiled.platform.Services;
import com.mrbysco.spoiled.registration.SpoiledComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TooltipUtil {
    @Nullable
    public static Component getTooltip(ItemStack stack) {
        if (stack.has(SpoiledComponents.SPOIL_TIMER.get())) {
            MutableComponent component;
            SpoilTimer spoilTimer = (SpoilTimer)stack.get(SpoiledComponents.SPOIL_TIMER.get());
            int timer = spoilTimer.timer();
            int timeMax = spoilTimer.maxTime();
            int percentage = (int)((double)timer / (double)timeMax * 100.0);
            if (Services.PLATFORM.showPercentage()) {
                component = Component.translatable((String)"spoiled.spoiling").withStyle(ChatFormatting.YELLOW);
                MutableComponent amount = Component.literal((String)String.valueOf(percentage)).withStyle(ChatFormatting.RED);
                MutableComponent percentageComponent = Component.literal((String)"%").withStyle(ChatFormatting.YELLOW);
                component.append((Component)amount).append((Component)percentageComponent);
            } else {
                component = percentage >= 0 && percentage <= 24 ? Component.translatable((String)"spoiled.spoiling.0").withStyle(ChatFormatting.GREEN) : (percentage >= 25 && percentage <= 49 ? Component.translatable((String)"spoiled.spoiling.25").withStyle(ChatFormatting.GREEN) : (percentage >= 50 && percentage <= 74 ? Component.translatable((String)"spoiled.spoiling.50").withStyle(ChatFormatting.YELLOW) : (percentage >= 75 && percentage <= 99 ? Component.translatable((String)"spoiled.spoiling.75").withStyle(ChatFormatting.YELLOW) : Component.translatable((String)"spoiled.spoiling.100").withStyle(ChatFormatting.RED))));
            }
            return component;
        }
        return null;
    }
}

