/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.natural;

import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.blockentity.IcestoneBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEventListener;
import org.jetbrains.annotations.Nullable;

public class IcestoneBlock
extends BaseEntityBlock {
    public static final MapCodec<IcestoneBlock> CODEC = IcestoneBlock.simpleCodec(IcestoneBlock::new);

    public IcestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new IcestoneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel level, T blockEntity) {
        IcestoneBlockEntity.FreezingListener freezingListener;
        if (blockEntity instanceof IcestoneBlockEntity) {
            IcestoneBlockEntity icestoneBlockEntity = (IcestoneBlockEntity)blockEntity;
            freezingListener = icestoneBlockEntity.getListener();
        } else {
            freezingListener = null;
        }
        return freezingListener;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : IcestoneBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)AetherBlockEntityTypes.ICESTONE.get()), IcestoneBlockEntity::serverTick);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

