/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.natural;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class LeavesWithParticlesBlock
extends LeavesBlock {
    private final Supplier<? extends ParticleOptions> particle;

    public LeavesWithParticlesBlock(Supplier<? extends ParticleOptions> particle, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(false)));
        this.particle = particle;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AetherBlockStateProperties.DOUBLE_DROPS});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (level.isClientSide() && random.nextInt(10) == 0) {
            for (int i = 0; i < 15; ++i) {
                double x = (double)pos.getX() + ((double)random.nextFloat() - 0.5) * 8.0;
                double y = (double)pos.getY() + ((double)random.nextFloat() - 0.5) * 8.0;
                double z = (double)pos.getZ() + ((double)random.nextFloat() - 0.5) * 8.0;
                double dx = ((double)random.nextFloat() - 0.5) * 0.5;
                double dy = ((double)random.nextFloat() - 0.5) * 0.5;
                double dz = ((double)random.nextFloat() - 0.5) * 0.5;
                level.addParticle(this.particle.get(), x, y, z, dx, dy, dz);
            }
        }
    }
}

