/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.utility;

import com.aetherteam.aether.blockentity.AbstractAetherFurnaceBlockEntity;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.blockentity.AltarBlockEntity;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AltarBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<AltarBlock> CODEC = AltarBlock.simpleCodec(AltarBlock::new);

    public AltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends AbstractFurnaceBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AltarBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : AltarBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)AetherBlockEntityTypes.ALTAR.get()), AbstractAetherFurnaceBlockEntity::serverTick);
    }

    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof AltarBlockEntity) {
            AltarBlockEntity altarBlockEntity = (AltarBlockEntity)blockEntity;
            player.openMenu((MenuProvider)altarBlockEntity);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 1.0 + (double)random.nextFloat() * 6.0 / 16.0;
            double z = (double)pos.getZ() + 0.5;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
            if (random.nextDouble() < 0.1) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, (SoundEvent)AetherSoundEvents.BLOCK_ALTAR_CRACKLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }
}

