/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.menu;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.component.menu.AetherMenuButton;
import com.aetherteam.aether.client.gui.screen.menu.CustomBranding;
import com.aetherteam.aether.client.gui.screen.menu.TitleScreenBehavior;
import com.aetherteam.aether.client.gui.screen.menu.logo.AetherLogoRenderer;
import com.aetherteam.aether.client.gui.screen.menu.splash.AetherSplashRenderer;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.cumulus.client.gui.screen.DynamicMenuButton;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.SplashRendererAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.Music;
import net.neoforged.neoforge.internal.BrandingControl;

public class AetherTitleScreen
extends TitleScreen
implements TitleScreenBehavior,
CustomBranding {
    public static final Music MENU = new Music(AetherSoundEvents.MUSIC_MENU, 20, 600, true);
    private final boolean alignedLeft;
    private Map<Component, AbstractWidget> widgetsByName = new HashMap<Component, AbstractWidget>();
    public int buttonRows = 0;
    public int lastY = 0;

    public AetherTitleScreen() {
        this(false);
    }

    public AetherTitleScreen(boolean alignedLeft) {
        this.alignedLeft = alignedLeft;
        TitleScreenAccessor accessor = (TitleScreenAccessor)((Object)this);
        accessor.aether$setFading(true);
        accessor.aether$setLogoRenderer(new AetherLogoRenderer(false, this.alignedLeft));
    }

    protected void init() {
        TitleScreenAccessor accessor = (TitleScreenAccessor)((Object)this);
        this.buttonRows = 0;
        this.lastY = 0;
        super.init();
        if (this.minecraft != null) {
            accessor.aether$setSplash(new AetherSplashRenderer(this.alignedLeft, ((SplashRendererAccessor)((TitleScreenAccessor)((Object)this)).aether$getSplash()).cumulus$getSplash()));
        }
        this.setupButtons();
        this.widgetsByName = this.children().stream().filter(e -> e instanceof AbstractWidget).map(e -> (AbstractWidget)e).collect(Collectors.toMap(AbstractWidget::getMessage, e -> e));
    }

    public void setupButtons() {
        if (((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue()) {
            Component component = ((TitleScreenAccessor)((Object)this)).callGetMultiplayerDisabledReason();
            boolean flag = component == null;
            Tooltip tooltip = component != null ? Tooltip.create((Component)component) : null;
            Button serverButton = this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"gui.aether.menu.server"), button -> {
                ServerData serverData = new ServerData("OATS", "oats.aether-mod.net", ServerData.Type.OTHER);
                ConnectScreen.startConnecting((Screen)this, (Minecraft)this.minecraft, (ServerAddress)ServerAddress.parseString((String)serverData.ip), (ServerData)serverData, (boolean)false, null);
            }).bounds(this.width / 2 - 100, this.height / 4 + 48 + 72, 200, 20).tooltip(tooltip).build());
            serverButton.active = flag;
            Predicate<AbstractWidget> predicate = abstractWidget -> abstractWidget.getMessage().equals((Object)Component.translatable((String)"menu.multiplayer")) || abstractWidget.getMessage().equals((Object)Component.translatable((String)"menu.online"));
            this.children().removeIf(button -> {
                AbstractWidget abstractWidget;
                return button instanceof AbstractWidget && predicate.test(abstractWidget = (AbstractWidget)button);
            });
            this.renderables.removeIf(button -> {
                AbstractWidget abstractWidget;
                return button instanceof AbstractWidget && predicate.test(abstractWidget = (AbstractWidget)button);
            });
        }
        for (Renderable renderable : this.renderables) {
            AbstractWidget abstractWidget2;
            Component buttonText;
            if (!(renderable instanceof AbstractWidget) || !TitleScreenBehavior.isImageButton(buttonText = (abstractWidget2 = (AbstractWidget)renderable).getMessage())) continue;
            abstractWidget2.visible = false;
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int xOffset = (Boolean)CumulusConfig.CLIENT.enable_menu_api.get() != false && (Boolean)CumulusConfig.CLIENT.enable_menu_list_button.get() != false ? -62 : 0;
        for (GuiEventListener child : this.children()) {
            if (child instanceof AetherMenuButton) {
                AetherMenuButton aetherButton = (AetherMenuButton)child;
                if (aetherButton.isMouseOver(mouseX, mouseY)) {
                    if (aetherButton.hoverOffset < 15) {
                        aetherButton.hoverOffset += 2;
                    }
                } else if (aetherButton.hoverOffset > 0) {
                    aetherButton.hoverOffset -= 2;
                }
            }
            if (!(child instanceof DynamicMenuButton)) continue;
            DynamicMenuButton dynamicMenuButton = (DynamicMenuButton)child;
            if (!dynamicMenuButton.enabled) continue;
            xOffset -= 24;
        }
        TitleScreenBehavior.super.handleImageButtons(this, xOffset);
        if (this.alignedLeft) {
            TitleScreenBehavior.super.handleEssentialButtonsForLeftMenu(this);
        }
    }

    @Override
    public boolean forEachLineBranding(boolean includeMC, boolean reverse, BiConsumer<Integer, String> lineConsumer, GuiGraphics guiGraphics, int i) {
        if (this.alignedLeft) {
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brandingLine, branding) -> {
                int n = this.width - this.font.width(branding) - 1;
                int n2 = brandingLine + 1;
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, branding, n, this.height - (10 + n2 * (9 + 1)), 0xFFFFFF | i);
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean forEachAboveCopyrightLineBranding(BiConsumer<Integer, String> lineConsumer, GuiGraphics guiGraphics, int i) {
        if (this.alignedLeft) {
            BrandingControl.forEachAboveCopyrightLine((brandingLine, branding) -> {
                int n = brandingLine + 1;
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, branding, 1, this.height - n * (9 + 1), 0xFFFFFF | i);
            });
            return true;
        }
        return false;
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T renderable) {
        Button button;
        if (renderable instanceof Button && TitleScreenBehavior.isMainButton((button = (Button)renderable).getMessage())) {
            AetherMenuButton aetherButton = new AetherMenuButton(this, button);
            Component buttonText = aetherButton.getMessage();
            if (this.isAlignedLeft()) {
                ++this.buttonRows;
            } else if (this.lastY < aetherButton.originalY) {
                this.lastY = aetherButton.originalY;
                ++this.buttonRows;
            }
            if (buttonText.equals((Object)Component.translatable((String)"gui.aether.menu.server"))) {
                aetherButton.serverButton = true;
                aetherButton.buttonCountOffset = 2;
            } else {
                aetherButton.buttonCountOffset = this.buttonRows;
            }
            if (((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue() && buttonText.equals((Object)Component.translatable((String)"menu.singleplayer"))) {
                ++this.buttonRows;
            }
            if (this.isAlignedLeft()) {
                aetherButton.setX(16);
                aetherButton.setY(50 + aetherButton.buttonCountOffset * 25);
                aetherButton.setWidth(200);
            } else {
                aetherButton.setY(this.height / 4 + 31 + 25 * (aetherButton.buttonCountOffset - 1));
            }
            return (T)super.addRenderableWidget((GuiEventListener)aetherButton);
        }
        return (T)super.addRenderableWidget(renderable);
    }

    public boolean isAlignedLeft() {
        return this.alignedLeft;
    }

    @Override
    public Map<Component, AbstractWidget> getWidgetsByName() {
        return this.widgetsByName;
    }
}

