/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.level;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.attachment.AetherTimeAttachment;
import com.aetherteam.aether.mixin.mixins.client.accessor.LevelRendererAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AetherSkyRenderEffects
extends DimensionSpecialEffects {
    private static final ResourceLocation MOON_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/sun.png");
    private final DimensionSpecialEffects OVERWORLD = new DimensionSpecialEffects.OverworldEffects();
    private final float[] sunriseCol = new float[4];
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private Vec3 prevCloudColor = Vec3.ZERO;

    public AetherSkyRenderEffects() {
        super(9.5f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
    }

    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        if (((Boolean)AetherConfig.CLIENT.colder_lightmap.get()).booleanValue()) {
            Vector3f vector3f = new Vector3f(skyDarken, skyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            Vector3f vector3f1 = new Vector3f();
            float f9 = LightTexture.getBrightness((DimensionType)level.dimensionType(), (int)pixelX) * skyLight;
            float f10 = f9 * (f9 * f9 * 0.6f + 0.4f);
            vector3f1.set(f10, f10, f10);
            boolean flag = level.effects().forceBrightLightmap();
            if (flag) {
                vector3f1.lerp((Vector3fc)new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                AetherSkyRenderEffects.clampColor(vector3f1);
            } else {
                Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).mul(blockLight);
                vector3f1.add((Vector3fc)vector3f2);
                vector3f1.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                if (Minecraft.getInstance().gameRenderer.getDarkenWorldAmount(partialTicks) > 0.0f) {
                    float darken = Minecraft.getInstance().gameRenderer.getDarkenWorldAmount(partialTicks);
                    Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f1).mul(0.7f, 0.6f, 0.6f);
                    vector3f1.lerp((Vector3fc)vector3f3, darken);
                }
            }
            colors.set((Vector3fc)vector3f1);
        }
    }

    private static void clampColor(Vector3f vector) {
        vector.set(Mth.clamp((float)vector.x(), (float)0.0f, (float)1.0f), Mth.clamp((float)vector.y(), (float)0.0f, (float)1.0f), Mth.clamp((float)vector.z(), (float)0.0f, (float)1.0f));
    }

    @Nullable
    public float[] getSunriseColor(float timeOfDay, float partialTicks) {
        if (((Boolean)AetherConfig.CLIENT.green_sunset.get()).booleanValue()) {
            float f1 = Mth.cos((float)(timeOfDay * ((float)Math.PI * 2))) - 0.0f;
            if (f1 >= -0.4f && f1 <= 0.4f) {
                float f3 = (f1 + 0.0f) / 0.4f * 0.5f + 0.5f;
                float f4 = 1.0f - (1.0f - Mth.sin((float)(f3 * (float)Math.PI))) * 0.99f;
                f4 *= f4;
                this.sunriseCol[0] = f3 * 0.5f + 0.0f;
                this.sunriseCol[1] = f3 * f3 * 0.3f + 0.3f;
                this.sunriseCol[2] = f3 * f3 * 0.5f + 0.3f;
                this.sunriseCol[3] = f4;
                return this.sunriseCol;
            }
            return null;
        }
        float f1 = Mth.cos((float)(timeOfDay * ((float)Math.PI * 2))) - 0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 + 0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - Mth.sin((float)(f3 * (float)Math.PI))) * 0.99f;
            f4 *= f4;
            this.sunriseCol[0] = f3 * 0.3f + 0.65f;
            this.sunriseCol[1] = f3 * f3 * 0.7f + 0.25f;
            this.sunriseCol[2] = f3 * f3 * 0.0f + 0.4f;
            this.sunriseCol[3] = f4;
            return this.sunriseCol;
        }
        return null;
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 color, float brightness) {
        return this.OVERWORLD.getBrightnessDependentFogColor(color, brightness);
    }

    public boolean isFoggyAt(int x, int z) {
        return this.OVERWORLD.isFoggyAt(x, z);
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        if (!((Boolean)AetherConfig.CLIENT.disable_clouds.get()).booleanValue()) {
            LevelRenderer levelRenderer = Minecraft.getInstance().levelRenderer;
            float cloudHeight = level.effects().getCloudHeight();
            if (!Float.isNaN(cloudHeight)) {
                double d1 = ((float)ticks + partialTick) * 0.03f;
                double d2 = (camX + d1) / 12.0;
                double d3 = cloudHeight - (float)camY + 0.33f;
                double d4 = camZ / 12.0 + (double)0.33f;
                d2 -= (double)(Mth.floor((double)(d2 / 2048.0)) * 2048);
                d4 -= (double)(Mth.floor((double)(d4 / 2048.0)) * 2048);
                float f3 = (float)(d2 - (double)Mth.floor((double)d2));
                float f4 = (float)(d3 / 4.0 - (double)Mth.floor((double)(d3 / 4.0))) * 4.0f;
                float f5 = (float)(d4 - (double)Mth.floor((double)d4));
                Vec3 vec3 = this.getCloudColor(level, partialTick);
                int i = Mth.floor((double)d2);
                int j = Mth.floor((double)(d3 / 4.0));
                int k = Mth.floor((double)d4);
                if (i != this.prevCloudX || j != this.prevCloudY || k != this.prevCloudZ || Minecraft.getInstance().options.getCloudsType() != ((LevelRendererAccessor)levelRenderer).aether$getPrevCloudsType() || this.prevCloudColor.distanceToSqr(vec3) > 2.0E-4) {
                    this.prevCloudX = i;
                    this.prevCloudY = j;
                    this.prevCloudZ = k;
                    this.prevCloudColor = vec3;
                    ((LevelRendererAccessor)levelRenderer).aether$setPrevCloudsType(Minecraft.getInstance().options.getCloudsType());
                    ((LevelRendererAccessor)levelRenderer).aether$setGenerateClouds(true);
                }
                if (((LevelRendererAccessor)levelRenderer).aether$isGenerateClouds()) {
                    ((LevelRendererAccessor)levelRenderer).aether$setGenerateClouds(false);
                    if (((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer() != null) {
                        ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().close();
                    }
                    ((LevelRendererAccessor)levelRenderer).aether$setCloudBuffer(new VertexBuffer(VertexBuffer.Usage.STATIC));
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().bind();
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().upload(((LevelRendererAccessor)levelRenderer).callBuildClouds(Tesselator.getInstance(), d2, d3, d4, vec3));
                    VertexBuffer.unbind();
                }
                FogRenderer.levelFogColor();
                poseStack.pushPose();
                poseStack.mulPose(modelViewMatrix);
                poseStack.scale(12.0f, 1.0f, 12.0f);
                poseStack.translate(-f3, f4, -f5);
                if (((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer() != null && RenderSystem.getShader() != null) {
                    int l;
                    ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().bind();
                    for (int i1 = l = ((LevelRendererAccessor)levelRenderer).aether$getPrevCloudsType() == CloudStatus.FANCY ? 0 : 1; i1 < 2; ++i1) {
                        RenderType rendertype = i1 == 0 ? RenderType.cloudsDepthOnly() : RenderType.clouds();
                        rendertype.setupRenderState();
                        ShaderInstance shaderinstance = RenderSystem.getShader();
                        ((LevelRendererAccessor)levelRenderer).aether$getCloudBuffer().drawWithShader(poseStack.last().pose(), projectionMatrix, shaderinstance);
                        rendertype.clearRenderState();
                    }
                    VertexBuffer.unbind();
                }
                poseStack.popPose();
            }
        }
        return true;
    }

    public Vec3 getCloudColor(ClientLevel level, float partialTick) {
        float f = level.getTimeOfDay(partialTick);
        float f1 = Mth.cos((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.clamp((float)f1, (float)0.0f, (float)1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = level.getRainLevel(partialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.725f;
            float f7 = 1.0f - f5 * 0.8f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = level.getThunderLevel(partialTick);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.5f;
            float f8 = 1.0f - f9 * 0.7f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        setupFog.run();
        if (!isFoggy && (fogtype = camera.getFluidInCamera()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !this.doesMobEffectBlockSky(camera)) {
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(modelViewMatrix);
            LevelRenderer levelRenderer = Minecraft.getInstance().levelRenderer;
            Vec3 vec3 = this.getSkyColor(level, Minecraft.getInstance().gameRenderer.getMainCamera().getPosition(), partialTick);
            float f = (float)vec3.x;
            float f1 = (float)vec3.y;
            float f2 = (float)vec3.z;
            FogRenderer.levelFogColor();
            Tesselator tesselator = Tesselator.getInstance();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            ShaderInstance shaderinstance = RenderSystem.getShader();
            ((LevelRendererAccessor)levelRenderer).aether$getSkyBuffer().bind();
            ((LevelRendererAccessor)levelRenderer).aether$getSkyBuffer().drawWithShader(poseStack.last().pose(), projectionMatrix, shaderinstance);
            VertexBuffer.unbind();
            RenderSystem.enableBlend();
            float[] sunriseColor = level.effects().getSunriseColor(level.getTimeOfDay(partialTick), partialTick);
            if (sunriseColor != null) {
                RenderSystem.setShader(GameRenderer::getPositionColorShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.pushPose();
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                float f3 = Mth.sin((float)level.getSunAngle(partialTick)) < 0.0f ? 180.0f : 0.0f;
                poseStack.mulPose(Axis.ZP.rotationDegrees(f3));
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                float f4 = sunriseColor[0];
                float f5 = sunriseColor[1];
                float f6 = sunriseColor[2];
                Matrix4f matrix4f = poseStack.last().pose();
                BufferBuilder sunriseBuffer = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
                sunriseBuffer.addVertex(matrix4f, 0.0f, 100.0f, 0.0f).setColor(f4, f5, f6, sunriseColor[3]);
                for (int j = 0; j <= 16; ++j) {
                    float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f8 = Mth.sin((float)f7);
                    float f9 = Mth.cos((float)f7);
                    sunriseBuffer.addVertex(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * sunriseColor[3]).setColor(sunriseColor[0], sunriseColor[1], sunriseColor[2], 0.0f);
                }
                BufferUploader.drawWithShader((MeshData)sunriseBuffer.buildOrThrow());
                poseStack.popPose();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.pushPose();
            float f11 = 1.0f - level.getRainLevel(partialTick);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)f11);
            this.drawCelestialBodies(partialTick, poseStack, level, tesselator);
            float f10 = level.getStarBrightness(partialTick) * f11;
            if (f10 > 0.0f) {
                RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
                FogRenderer.setupNoFog();
                ((LevelRendererAccessor)levelRenderer).aether$getStarBuffer().bind();
                ((LevelRendererAccessor)levelRenderer).aether$getStarBuffer().drawWithShader(poseStack.last().pose(), projectionMatrix, GameRenderer.getPositionShader());
                VertexBuffer.unbind();
                setupFog.run();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.popPose();
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    private boolean doesMobEffectBlockSky(Camera pCamera) {
        Entity entity = pCamera.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS);
    }

    public Vec3 getSkyColor(ClientLevel level, Vec3 pos, float partialTick) {
        float f9;
        float f = level.getTimeOfDay(partialTick);
        Vec3 vec3 = pos.subtract(2.0, 2.0, 2.0).scale(0.25);
        BiomeManager biomeManager = level.getBiomeManager();
        Vec3 vec31 = CubicSampler.gaussianSampleVec3((Vec3)vec3, (x, y, z) -> Vec3.fromRGB24((int)((Biome)biomeManager.getNoiseBiomeAtQuart(x, y, z).value()).getSkyColor()));
        float f1 = Mth.cos((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.clamp((float)f1, (float)0.0f, (float)1.0f);
        float f2 = (float)vec31.x() * f1;
        float f3 = (float)vec31.y() * f1;
        float f4 = (float)vec31.z() * f1;
        float f5 = level.getRainLevel(partialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.61f;
            float f7 = 1.0f - f5 * 0.2f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = level.getThunderLevel(partialTick)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.48f;
            float f8 = 1.0f - f9 * 0.21f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if (!((Boolean)Minecraft.getInstance().options.hideLightningFlash().get()).booleanValue() && level.getSkyFlashTime() > 0) {
            float f11 = (float)level.getSkyFlashTime() - partialTick;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + f11;
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    private void drawCelestialBodies(float partialTick, PoseStack poseStack, ClientLevel level, Tesselator tesselator) {
        float moonOpacity;
        float sunOpacity;
        long dayTime = level.getDayTime() % (long)AetherTimeAttachment.getTicksPerDay();
        if (dayTime > 23800L * (long)AetherTimeAttachment.getTicksPerDayMultiplier()) {
            sunOpacity = Math.min((float)(dayTime -= 23800L * (long)AetherTimeAttachment.getTicksPerDayMultiplier()) * 0.00167f, 1.0f);
            moonOpacity = Math.max(1.0f - (float)dayTime * 0.00167f, 0.0f);
        } else if (dayTime > 12800L * (long)AetherTimeAttachment.getTicksPerDayMultiplier()) {
            sunOpacity = Math.max(1.0f - (float)(dayTime -= 12800L * (long)AetherTimeAttachment.getTicksPerDayMultiplier()) * 0.00167f, 0.0f);
            moonOpacity = Math.min((float)dayTime * 0.00167f, 1.0f);
        } else {
            sunOpacity = 1.0f;
            moonOpacity = 0.0f;
        }
        sunOpacity -= level.getRainLevel(partialTick);
        moonOpacity -= level.getRainLevel(partialTick);
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(level.getTimeOfDay(partialTick) * 360.0f));
        Matrix4f matrix4f1 = poseStack.last().pose();
        float celestialOffset = 30.0f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)sunOpacity);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
        BufferBuilder sunBuffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        sunBuffer.addVertex(matrix4f1, -celestialOffset, 100.0f, -celestialOffset).setUv(0.0f, 0.0f);
        sunBuffer.addVertex(matrix4f1, celestialOffset, 100.0f, -celestialOffset).setUv(1.0f, 0.0f);
        sunBuffer.addVertex(matrix4f1, celestialOffset, 100.0f, celestialOffset).setUv(1.0f, 1.0f);
        sunBuffer.addVertex(matrix4f1, -celestialOffset, 100.0f, celestialOffset).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)sunBuffer.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)moonOpacity);
        celestialOffset = 20.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
        int moonPhase = level.getMoonPhase();
        int textureX = moonPhase % 4;
        int textureY = moonPhase / 4 % 2;
        float uLeft = (float)textureX / 4.0f;
        float vDown = (float)textureY / 2.0f;
        float uRight = (float)(textureX + 1) / 4.0f;
        float vUp = (float)(textureY + 1) / 2.0f;
        BufferBuilder moonBuffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        moonBuffer.addVertex(matrix4f1, -celestialOffset, -100.0f, celestialOffset).setUv(uRight, vUp);
        moonBuffer.addVertex(matrix4f1, celestialOffset, -100.0f, celestialOffset).setUv(uLeft, vUp);
        moonBuffer.addVertex(matrix4f1, celestialOffset, -100.0f, -celestialOffset).setUv(uLeft, vDown);
        moonBuffer.addVertex(matrix4f1, -celestialOffset, -100.0f, -celestialOffset).setUv(uRight, vDown);
        BufferUploader.drawWithShader((MeshData)moonBuffer.buildOrThrow());
    }
}

