/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.player.layer;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.entity.projectile.dart.AbstractDart;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DartLayer<T extends LivingEntity, M extends PlayerModel<T>>
extends StuckInBodyLayer<T, M> {
    private final EntityRenderDispatcher dispatcher;
    private final Function<Entity, AbstractDart> dart;
    private final Function<AetherPlayerAttachment, Integer> dartCount;
    private final float offset;

    public DartLayer(EntityRenderDispatcher renderDispatcher, LivingEntityRenderer<T, M> renderer, Function<Entity, AbstractDart> dart, Function<AetherPlayerAttachment, Integer> dartCount, float offset) {
        super(renderer);
        this.dispatcher = renderDispatcher;
        this.dart = dart;
        this.dartCount = dartCount;
        this.offset = offset;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        int i = this.numStuck(livingEntity);
        float offset = this.offset;
        RandomSource randomSource = RandomSource.create((long)((long)((double)livingEntity.getId() * (0.25 * (double)offset))));
        if (i > 0) {
            for (int j = 0; j < i; ++j) {
                poseStack.pushPose();
                ModelPart modelPart = ((PlayerModel)this.getParentModel()).getRandomModelPart(randomSource);
                ModelPart.Cube cube = modelPart.getRandomCube(randomSource);
                modelPart.translateAndRotate(poseStack);
                float f = randomSource.nextFloat();
                float f1 = randomSource.nextFloat();
                float f2 = randomSource.nextFloat();
                float f3 = Mth.lerp((float)f, (float)cube.minX, (float)cube.maxX) / 16.0f;
                float f4 = Mth.lerp((float)f1, (float)cube.minY, (float)cube.maxY) / 16.0f;
                float f5 = Mth.lerp((float)f2, (float)cube.minZ, (float)cube.maxZ) / 16.0f;
                poseStack.translate(f3, f4, f5);
                f = -1.0f * (f * 2.0f - 1.0f);
                f1 = -1.0f * (f1 * 2.0f - 1.0f);
                f2 = -1.0f * (f2 * 2.0f - 1.0f);
                this.renderStuckItem(poseStack, buffer, packedLight, (Entity)livingEntity, f, f1, f2, partialTicks);
                poseStack.popPose();
            }
        }
    }

    protected void renderStuckItem(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Entity entity, float x, float y, float z, float partialTick) {
        float f = Mth.sqrt((float)(x * x + z * z));
        AbstractDart dart = this.dart.apply(entity);
        dart.setPos(entity.position());
        dart.setYRot((float)(Math.atan2(x, z) * 57.2957763671875));
        dart.setXRot((float)(Math.atan2(y, f) * 57.2957763671875));
        dart.yRotO = dart.getYRot();
        dart.xRotO = dart.getXRot();
        this.dispatcher.render((Entity)dart, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, packedLight);
    }

    protected int numStuck(T entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return this.dartCount.apply((AetherPlayerAttachment)player.getData(AetherDataAttachments.AETHER_PLAYER));
        }
        return 0;
    }
}

