/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.builders;

import com.aetherteam.aether.block.AetherBlockStateProperties;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.data.resources.registries.AetherNoises;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class AetherNoiseBuilders {
    private static final SurfaceRules.RuleSource GRASS_BLOCK = SurfaceRules.state((BlockState)((BlockState)((Block)AetherBlocks.AETHER_GRASS_BLOCK.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))));
    private static final SurfaceRules.RuleSource DIRT = SurfaceRules.state((BlockState)((BlockState)((Block)AetherBlocks.AETHER_DIRT.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true))));

    public static NoiseGeneratorSettings skylandsNoiseSettings(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise) {
        BlockState holystone = (BlockState)((Block)AetherBlocks.HOLYSTONE.get()).defaultBlockState().setValue((Property)AetherBlockStateProperties.DOUBLE_DROPS, (Comparable)Boolean.valueOf(true));
        return new NoiseGeneratorSettings(new NoiseSettings(0, 128, 2, 1), holystone, Blocks.WATER.defaultBlockState(), AetherNoiseBuilders.makeNoiseRouter(densityFunctions, noise), AetherNoiseBuilders.aetherSurfaceRules(), List.of(), -64, false, false, false, false);
    }

    public static SurfaceRules.RuleSource aetherSurfaceRules() {
        SurfaceRules.RuleSource surface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)surface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)DIRT)});
    }

    private static NoiseRouter makeNoiseRouter(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise) {
        return AetherNoiseBuilders.createNoiseRouter(densityFunctions, noise, AetherNoiseBuilders.buildFinalDensity(densityFunctions));
    }

    private static DensityFunction buildFinalDensity(HolderGetter<DensityFunction> densityFunctions) {
        DensityFunction density = AetherNoiseBuilders.getFunction(densityFunctions, (ResourceKey<DensityFunction>)ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"base_3d_noise_aether")));
        density = DensityFunctions.add((DensityFunction)density, (DensityFunction)DensityFunctions.constant((double)-0.13));
        density = AetherNoiseBuilders.slide(density, 0, 128, 72, 0, -0.2, 8, 40, -0.1);
        density = DensityFunctions.add((DensityFunction)density, (DensityFunction)DensityFunctions.constant((double)-0.05));
        density = DensityFunctions.blendDensity((DensityFunction)density);
        density = DensityFunctions.interpolated((DensityFunction)density);
        density = density.squeeze();
        return density;
    }

    private static DensityFunction slide(DensityFunction density, int minY, int maxY, int fromYTop, int toYTop, double offset1, int fromYBottom, int toYBottom, double offset2) {
        DensityFunction topSlide = DensityFunctions.yClampedGradient((int)(minY + maxY - fromYTop), (int)(minY + maxY - toYTop), (double)1.0, (double)0.0);
        density = DensityFunctions.lerp((DensityFunction)topSlide, (double)offset1, (DensityFunction)density);
        DensityFunction bottomSlide = DensityFunctions.yClampedGradient((int)(minY + fromYBottom), (int)(minY + toYBottom), (double)0.0, (double)1.0);
        return DensityFunctions.lerp((DensityFunction)bottomSlide, (double)offset2, (DensityFunction)density);
    }

    private static NoiseRouter createNoiseRouter(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noise, DensityFunction finalDensity) {
        DensityFunction shiftX = AetherNoiseBuilders.getFunction(densityFunctions, (ResourceKey<DensityFunction>)ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"shift_x")));
        DensityFunction shiftZ = AetherNoiseBuilders.getFunction(densityFunctions, (ResourceKey<DensityFunction>)ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"shift_z")));
        DensityFunction temperature = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)noise.getOrThrow(AetherNoises.TEMPERATURE));
        DensityFunction vegetation = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)noise.getOrThrow(AetherNoises.VEGETATION));
        return new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), temperature, vegetation, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), finalDensity, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> densityFunctions, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)densityFunctions.getOrThrow(key));
    }
}

