/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class AetherDamageTypes {
    public static final ResourceKey<DamageType> CLOUD_CRYSTAL = AetherDamageTypes.createKey("cloud_crystal");
    public static final ResourceKey<DamageType> CRUSH = AetherDamageTypes.createKey("crush");
    public static final ResourceKey<DamageType> FIRE_CRYSTAL = AetherDamageTypes.createKey("fire_crystal");
    public static final ResourceKey<DamageType> FLOATING_BLOCK = AetherDamageTypes.createKey("floating_block");
    public static final ResourceKey<DamageType> ICE_CRYSTAL = AetherDamageTypes.createKey("ice_crystal");
    public static final ResourceKey<DamageType> INCINERATION = AetherDamageTypes.createKey("incineration");
    public static final ResourceKey<DamageType> INEBRIATION = AetherDamageTypes.createKey("inebriation");
    public static final ResourceKey<DamageType> THUNDER_CRYSTAL = AetherDamageTypes.createKey("thunder_crystal");

    public static void bootstrap(BootstrapContext<DamageType> context) {
        context.register(CLOUD_CRYSTAL, (Object)new DamageType("aether.cloud_crystal", 0.1f));
        context.register(CRUSH, (Object)new DamageType("aether.crush", 0.1f));
        context.register(FIRE_CRYSTAL, (Object)new DamageType("aether.fire_crystal", 0.1f, DamageEffects.BURNING));
        context.register(FLOATING_BLOCK, (Object)new DamageType("aether.floating_block", 0.1f));
        context.register(ICE_CRYSTAL, (Object)new DamageType("aether.ice_crystal", 0.1f, DamageEffects.FREEZING));
        context.register(INCINERATION, (Object)new DamageType("aether.incineration", 0.1f, DamageEffects.BURNING));
        context.register(INEBRIATION, (Object)new DamageType("aether.inebriation", 0.1f));
        context.register(THUNDER_CRYSTAL, (Object)new DamageType("aether.thunder_crystal", 0.1f));
    }

    private static ResourceKey<DamageType> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aether", (String)name));
    }

    public static DamageSource damageSource(Level level, ResourceKey<DamageType> key) {
        return new DamageSource(level.holderOrThrow(key));
    }

    public static DamageSource entityDamageSource(Level level, ResourceKey<DamageType> key, @Nullable Entity entity) {
        return new DamageSource(level.holderOrThrow(key), entity);
    }

    public static DamageSource indirectEntityDamageSource(Level level, ResourceKey<DamageType> key, @Nullable Entity source, @Nullable Entity trueSource) {
        return new DamageSource(level.holderOrThrow(key), source, trueSource);
    }
}

