/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.block;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.block.Floatable;
import com.aetherteam.aether.block.miscellaneous.FloatingBlock;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.mixin.mixins.common.accessor.ConcretePowderBlockAccessor;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FloatingBlockEntity
extends Entity {
    private static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.defineId(FloatingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private BlockState blockState = Blocks.SAND.defaultBlockState();
    private int time;
    private boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    private int floatDistance;
    @Nullable
    private CompoundTag blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    private boolean natural = true;

    public FloatingBlockEntity(EntityType<? extends FloatingBlockEntity> type, Level level) {
        super(type, level);
    }

    public FloatingBlockEntity(Level level, double x, double y, double z, BlockState state) {
        this((EntityType<? extends FloatingBlockEntity>)((EntityType)AetherEntityTypes.FLOATING_BLOCK.get()), level);
        this.blockState = state;
        this.blocksBuilding = true;
        this.setPos(x, y + (double)((1.0f - this.getBbHeight()) / 2.0f), z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_START_POS, (Object)BlockPos.ZERO);
    }

    public void tick() {
        if (this.getBlockState().isAir()) {
            this.discard();
        } else {
            Level level;
            Block block = this.getBlockState().getBlock();
            if (this.time++ == 0) {
                BlockPos blockPos = this.blockPosition();
                if (this.level().getBlockState(blockPos).is(block)) {
                    this.level().removeBlock(blockPos, false);
                }
            }
            this.applyGravity();
            this.floatDistance = this.blockPosition().getY() - this.getStartPos().getY();
            if (this.level().isClientSide()) {
                this.spawnFloatingBlockParticles();
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.handlePortal();
            if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.isAlive() || this.forceTickAfterTeleportToDuplicate) {
                    BlockHitResult blockHitResult;
                    BlockPos blockPos1 = this.blockPosition();
                    boolean isConcrete = this.getBlockState().getBlock() instanceof ConcretePowderBlock;
                    boolean canConvert = isConcrete && this.blockState.canBeHydrated((BlockGetter)this.level(), blockPos1, this.level().getFluidState(blockPos1), blockPos1);
                    double d0 = this.getDeltaMovement().lengthSqr();
                    if (isConcrete && d0 > 1.0 && (blockHitResult = this.level().clip(new ClipContext(new Vec3(this.xo, this.yo, this.zo), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).getType() != HitResult.Type.MISS && this.blockState.canBeHydrated((BlockGetter)this.level(), blockPos1, this.level().getFluidState(blockHitResult.getBlockPos()), blockHitResult.getBlockPos())) {
                        blockPos1 = blockHitResult.getBlockPos();
                        canConvert = true;
                    }
                    if (!(this.verticalCollision && !this.onGround() || canConvert)) {
                        if (!(this.level().isClientSide() || (this.time <= 100 || blockPos1.getY() > this.level().getMinBuildHeight() && blockPos1.getY() <= this.level().getMaxBuildHeight()) && this.time <= 600)) {
                            if ((!this.natural || !this.getBlockState().requiresCorrectToolForDrops()) && this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                this.dropBlock(this.getBlockState());
                            }
                            this.discard();
                        }
                    } else {
                        BlockState blockState = this.level().getBlockState(blockPos1);
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                        if (!blockState.is(Blocks.MOVING_PISTON)) {
                            if (!this.cancelDrop) {
                                boolean canBlockSurvive;
                                boolean canBeReplaced = blockState.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), blockPos1, Direction.UP, ItemStack.EMPTY, Direction.DOWN));
                                boolean isAboveFree = FloatingBlock.isFree(this.level().getBlockState(blockPos1.above())) && (!isConcrete || !canConvert);
                                boolean bl = canBlockSurvive = this.getBlockState().canSurvive((LevelReader)this.level(), blockPos1) && !isAboveFree;
                                if (canBeReplaced && canBlockSurvive || this.natural && blockState.getBlock().defaultDestroyTime() >= 0.0f) {
                                    if (this.getBlockState().hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level().getFluidState(blockPos1).is((Fluid)Fluids.WATER)) {
                                        this.blockState = (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                                    }
                                    BlockState previousBlockState = this.level().getBlockState(blockPos1);
                                    if (this.level().setBlock(blockPos1, this.getBlockState(), 3)) {
                                        BlockEntity blockEntity;
                                        if (this.natural && !previousBlockState.isAir()) {
                                            this.dropBlock(previousBlockState);
                                        }
                                        serverLevel.getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockPos1, this.level().getBlockState(blockPos1)));
                                        this.discard();
                                        Block block2 = block;
                                        Objects.requireNonNull(block2);
                                        Block block3 = block2;
                                        int n = 0;
                                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Floatable.class, ConcretePowderBlock.class, AnvilBlock.class}, (Object)block3, n)) {
                                            case 0: {
                                                Floatable floatable = (Floatable)block3;
                                                floatable.onCollide(this.level(), blockPos1, this.getBlockState(), blockState, this);
                                                break;
                                            }
                                            case 1: {
                                                ConcretePowderBlock concretePowderBlock = (ConcretePowderBlock)block3;
                                                if (!ConcretePowderBlockAccessor.callShouldSolidify((BlockGetter)this.level(), blockPos1, blockState)) break;
                                                ConcretePowderBlockAccessor concretePowderBlockAccessor = (ConcretePowderBlockAccessor)concretePowderBlock;
                                                this.level().setBlock(blockPos1, concretePowderBlockAccessor.aether$getConcrete().defaultBlockState(), 3);
                                                break;
                                            }
                                            case 2: {
                                                AnvilBlock anvilBlock = (AnvilBlock)block3;
                                                if (this.isSilent()) break;
                                                this.level().levelEvent(1029, blockPos1, 0);
                                                break;
                                            }
                                        }
                                        if (this.blockData != null && this.getBlockState().hasBlockEntity() && (blockEntity = this.level().getBlockEntity(blockPos1)) != null) {
                                            CompoundTag tag = blockEntity.saveWithoutMetadata((HolderLookup.Provider)this.level().registryAccess());
                                            for (String s : this.blockData.getAllKeys()) {
                                                tag.put(s, this.blockData.get(s).copy());
                                            }
                                            try {
                                                blockEntity.loadWithComponents(tag, (HolderLookup.Provider)this.level().registryAccess());
                                            }
                                            catch (Exception exception) {
                                                Aether.LOGGER.error("Failed to load block entity from floating block", (Throwable)exception);
                                            }
                                            blockEntity.setChanged();
                                        }
                                    } else if ((!this.natural || !this.getBlockState().requiresCorrectToolForDrops()) && this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                        this.discard();
                                        this.callOnBrokenAfterFall(block, blockPos1);
                                        this.dropBlock(this.getBlockState());
                                    }
                                } else {
                                    this.discard();
                                    if ((!this.natural || !this.getBlockState().requiresCorrectToolForDrops() || blockState.getBlock().defaultDestroyTime() < 0.0f) && this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                        this.callOnBrokenAfterFall(block, blockPos1);
                                        this.dropBlock(this.getBlockState());
                                    }
                                }
                            } else {
                                this.discard();
                                this.callOnBrokenAfterFall(block, blockPos1);
                            }
                        }
                    }
                }
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
    }

    public void setHurtsEntities(float fallDamagePerDistance, int fallDamageMax) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = fallDamagePerDistance;
        this.fallDamageMax = fallDamageMax;
    }

    private void dropBlock(BlockState state) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ItemStack stack : Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)this.blockPosition(), null)) {
                this.spawnAtLocation(stack);
            }
        }
    }

    public void callOnBrokenAfterFall(Block block, BlockPos pos) {
        if (block instanceof Floatable) {
            Floatable floatable = (Floatable)block;
            floatable.onBrokenAfterCollide(this.level(), pos, this);
        }
    }

    protected void applyGravity() {
        double d0 = this.getGravity();
        if (d0 != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, d0, 0.0));
        }
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        int i;
        if (this.hurtEntities && (i = this.floatDistance) >= 0) {
            DamageSource damageSource;
            Predicate predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
            Block block = this.blockState.getBlock();
            if (block instanceof Floatable) {
                Floatable floatable = (Floatable)block;
                damageSource = floatable.getFallDamageSource(this);
            } else {
                damageSource = AetherDamageTypes.entityDamageSource(this.level(), AetherDamageTypes.FLOATING_BLOCK, this);
            }
            DamageSource damageSource2 = damageSource;
            float f = Math.min(Mth.floor((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
            this.level().getEntities((Entity)this, this.getBoundingBox(), predicate).forEach(entity -> entity.hurt(damageSource2, f));
            boolean flag = this.getBlockState().is(BlockTags.ANVIL);
            if (flag && f > 0.0f && this.random.nextFloat() < 0.05f + (float)i * 0.05f) {
                BlockState blockstate = AnvilBlock.damage((BlockState)this.getBlockState());
                if (blockstate == null) {
                    this.disableDrop();
                } else {
                    this.blockState = blockstate;
                }
            }
        }
        return false;
    }

    private void spawnFloatingBlockParticles() {
        if (this.random.nextInt(8) == 0) {
            double d0 = this.getX() - 0.5 + this.random.nextDouble();
            double d1 = this.getY() - 0.05;
            double d2 = this.getZ() - 0.5 + this.random.nextDouble();
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, this.getBlockState()), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void setStartPos(BlockPos pOrigin) {
        this.getEntityData().set(DATA_START_POS, (Object)pOrigin);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.getEntityData().get(DATA_START_POS);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    protected Component getTypeName() {
        return Component.translatable((String)"entity.aether.floating_block_type", (Object[])new Object[]{this.blockState.getBlock().getName()});
    }

    @Nullable
    public Entity changeDimension(DimensionTransition transition) {
        ResourceKey newDimension = transition.newLevel().dimension();
        ResourceKey currentDimension = this.level().dimension();
        boolean flag = (currentDimension == Level.END || newDimension == Level.END) && currentDimension != newDimension;
        Entity entity = super.changeDimension(transition);
        this.forceTickAfterTeleportToDuplicate = entity != null && flag;
        return entity;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockState));
        tag.putInt("Time", this.time);
        tag.putBoolean("DropItem", this.dropItem);
        tag.putBoolean("HurtEntities", this.hurtEntities);
        tag.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        tag.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            tag.put("TileEntityData", (Tag)this.blockData);
        }
        tag.putBoolean("Natural", this.natural);
        tag.putBoolean("CancelDrop", this.cancelDrop);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("BlockState")) {
            this.blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("BlockState"));
        }
        if (tag.contains("Time")) {
            this.time = tag.getInt("Time");
        }
        if (tag.contains("HurtEntities", 99)) {
            this.hurtEntities = tag.getBoolean("HurtEntities");
            this.fallDamagePerDistance = tag.getFloat("FallHurtAmount");
            this.fallDamageMax = tag.getInt("FallHurtMax");
        } else if (this.blockState.is(BlockTags.ANVIL)) {
            this.hurtEntities = true;
        }
        if (tag.contains("DropItem", 99)) {
            this.dropItem = tag.getBoolean("DropItem");
        }
        if (tag.contains("TileEntityData", 10)) {
            this.blockData = tag.getCompound("TileEntityData");
        }
        if (this.blockState.isAir()) {
            this.blockState = Blocks.SAND.defaultBlockState();
        }
        if (tag.contains("CancelDrop")) {
            this.cancelDrop = tag.getBoolean("CancelDrop");
        }
        if (tag.contains("Natural", 99)) {
            this.natural = tag.getBoolean("Natural");
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity, Block.getId((BlockState)this.getBlockState()));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.blockState = Block.stateById((int)packet.getData());
        this.blocksBuilding = true;
        double d0 = packet.getX();
        double d1 = packet.getY();
        double d2 = packet.getZ();
        this.setPos(d0, d1, d2);
        this.setStartPos(this.blockPosition());
    }

    public void fillCrashReportCategory(CrashReportCategory category) {
        super.fillCrashReportCategory(category);
        category.setDetail("Imitating BlockState", (Object)this.getBlockState().toString());
    }
}

