/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.crystal;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import com.aetherteam.aether.entity.projectile.crystal.WeaknessDamage;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class CloudCrystal
extends AbstractCrystal
implements WeaknessDamage {
    public CloudCrystal(EntityType<? extends CloudCrystal> entityType, Level level) {
        super(entityType, level);
    }

    public CloudCrystal(Level level) {
        super((EntityType<? extends AbstractCrystal>)((EntityType)AetherEntityTypes.CLOUD_CRYSTAL.get()), level);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            float bonus;
            LivingEntity livingEntity = (LivingEntity)entity;
            float f = bonus = entity.getType().is(AetherTags.Entities.FIRE_MOB) ? 3.0f : 0.0f;
            if (livingEntity.hurt(AetherDamageTypes.indirectEntityDamageSource(this.level(), AetherDamageTypes.CLOUD_CRYSTAL, (Entity)this, this.getOwner()), 5.0f + bonus)) {
                WeaknessDamage.super.damageWithWeakness(this, livingEntity, this.random);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (!this.level().isClientSide()) {
            this.discard();
        }
    }

    @Override
    protected void tickMovement() {
        super.tickMovement();
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.99f));
    }

    @Override
    protected ParticleOptions getExplosionParticle() {
        return (ParticleOptions)AetherParticleTypes.FROZEN.get();
    }

    @Override
    @Nullable
    public SoundEvent getImpactExplosionSoundEvent() {
        return (SoundEvent)AetherSoundEvents.ENTITY_CLOUD_CRYSTAL_EXPLODE.get();
    }

    @Override
    public boolean isPickable() {
        return false;
    }
}

