/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherGameEvents;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.FreezingBlock;
import com.aetherteam.aether.blockentity.IcestoneBlockEntity;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.ban.BlockBanRecipe;
import com.aetherteam.aether.recipe.recipes.ban.ItemBanRecipe;
import com.aetherteam.aether.recipe.recipes.block.PlacementConversionRecipe;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class RecipeHooks {
    public static boolean checkInteractionBanned(Player player, Level level, BlockPos pos, Direction face, ItemStack stack, BlockState state, boolean spawnParticles) {
        if (RecipeHooks.isItemPlacementBanned(level, pos, face, stack, spawnParticles)) {
            player.displayClientMessage((Component)Component.translatable((String)"aether.banned_item", (Object[])new Object[]{stack.getItem().getName(stack)}), true);
            return true;
        }
        if (level.getBiome(pos).is(AetherTags.Biomes.ULTRACOLD) && ((Boolean)AetherConfig.SERVER.enable_bed_explosions.get()).booleanValue() && state.is(BlockTags.BEDS) && state.getBlock() != AetherBlocks.SKYROOT_BED.get()) {
            if (!level.isClientSide()) {
                BlockPos blockpos;
                if (state.getValue((Property)BedBlock.PART) != BedPart.HEAD) {
                    pos = pos.relative((Direction)state.getValue((Property)BedBlock.FACING));
                    state = level.getBlockState(pos);
                }
                if (level.getBlockState(blockpos = pos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getOpposite())).is(BlockTags.BEDS) && level.getBlockState(blockpos).getBlock() != AetherBlocks.SKYROOT_BED.get()) {
                    level.removeBlock(blockpos, false);
                }
                Vec3 vec3 = pos.getCenter();
                level.explode(null, level.damageSources().badRespawnPointExplosion(vec3), null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5.0f, true, Level.ExplosionInteraction.BLOCK);
            }
            player.swing(InteractionHand.MAIN_HAND);
            return true;
        }
        return false;
    }

    public static boolean isItemPlacementBanned(Level level, BlockPos pos, Direction face, ItemStack stack, boolean spawnParticles) {
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor((RecipeType)AetherRecipeTypes.ITEM_PLACEMENT_BAN.get())) {
            if (!((ItemBanRecipe)recipe.value()).banItem(level, pos, face, stack, spawnParticles)) continue;
            return true;
        }
        return false;
    }

    public static void checkExistenceBanned(LevelAccessor levelAccessor, BlockPos pos) {
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            BlockState state = levelAccessor.getBlockState(pos);
            if (RecipeHooks.isBlockPlacementBanned(level, pos, state)) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                if (state.getBlock().asItem() != Items.AIR) {
                    Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
                }
            } else {
                RecipeHooks.isBlockPlacementConvertable(level, pos, state);
            }
        }
    }

    private static boolean isBlockPlacementBanned(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor((RecipeType)AetherRecipeTypes.BLOCK_PLACEMENT_BAN.get())) {
                if (!((BlockBanRecipe)recipe.value()).banBlock(level, pos, state)) continue;
                return true;
            }
        }
        return false;
    }

    private static void isBlockPlacementConvertable(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor((RecipeType)AetherRecipeTypes.PLACEMENT_CONVERSION.get())) {
                if (!((PlacementConversionRecipe)recipe.value()).convert(level, pos, state)) continue;
                return;
            }
        }
    }

    public static void banOrConvert(LevelAccessor accessor, BlockPos pos) {
        if (accessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)accessor;
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.5;
            for (int i = 0; i < 10; ++i) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            serverLevel.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void sendIcestoneFreezableUpdateEvent(LevelAccessor accessor, BlockPos pos) {
        Level level;
        if (accessor instanceof Level && !(level = (Level)accessor).isClientSide()) {
            BlockState oldBlockState = level.getBlockState(pos);
            FreezingBlock.cacheRecipes(level);
            if (FreezingBlock.matchesCache(oldBlockState.getBlock(), oldBlockState) != null) {
                level.gameEvent(AetherGameEvents.ICESTONE_FREEZABLE_UPDATE, pos, GameEvent.Context.of((BlockState)oldBlockState));
            }
        }
    }

    public static boolean preventBlockFreezing(LevelAccessor accessor, BlockPos sourcePos, BlockPos pos) {
        BlockEntity blockEntity = accessor.getBlockEntity(sourcePos);
        if (blockEntity instanceof IcestoneBlockEntity) {
            IcestoneBlockEntity blockEntity2 = (IcestoneBlockEntity)blockEntity;
            for (Map.Entry entry : blockEntity2.getLastBrokenPositions().entrySet()) {
                if (!((BlockPos)entry.getKey()).equals((Object)pos) || (Integer)entry.getValue() <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

