/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.jei.categories.ban;

import com.aetherteam.aether.integration.jei.categories.BiomeTooltip;
import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.nitrogen.integration.jei.BlockStateRenderer;
import com.aetherteam.nitrogen.integration.jei.FluidStateRenderer;
import com.aetherteam.nitrogen.integration.jei.categories.AbstractRecipeCategory;
import com.aetherteam.nitrogen.recipe.BlockPropertyPair;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractPlacementBanRecipeCategory<T, S extends Predicate<T>, F extends RecipeInput, R extends AbstractPlacementBanRecipe<T, S, F>>
extends AbstractRecipeCategory<R>
implements BiomeTooltip {
    protected final IPlatformFluidHelper<?> fluidHelper;
    private final IDrawable slot;

    public AbstractPlacementBanRecipeCategory(IGuiHelper guiHelper, String id, ResourceLocation uid, IDrawable background, IDrawable icon, RecipeType<R> recipeType, IPlatformFluidHelper<?> fluidHelper) {
        super(id, uid, background, icon, recipeType);
        this.fluidHelper = fluidHelper;
        this.slot = guiHelper.getSlotDrawable();
    }

    public Component getTitle() {
        return Component.translatable((String)("gui.aether.jei." + this.id));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, R recipe, IFocusGroup focusGroup) {
        BlockPropertyPair[] pairs;
        Optional<BlockStateIngredient> bypassBlockIngredient = ((AbstractPlacementBanRecipe)recipe).getBypassBlock();
        if (bypassBlockIngredient.isPresent() && !bypassBlockIngredient.get().isEmpty() && (pairs = bypassBlockIngredient.get().getPairs()) != null) {
            List<Object> ingredients = this.setupIngredients(pairs);
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 99, 1).addIngredientsUnsafe(ingredients)).setCustomRenderer((IIngredientType)Services.PLATFORM.getFluidHelper().getFluidIngredientType(), (IIngredientRenderer)new FluidStateRenderer(Services.PLATFORM.getFluidHelper())).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new BlockStateRenderer(pairs));
        }
    }

    protected List<Object> setupIngredients(BlockPropertyPair[] pairs) {
        ArrayList<Object> ingredients = new ArrayList<Object>();
        if (Minecraft.getInstance().level != null) {
            for (BlockPropertyPair pair : pairs) {
                ItemStack stack;
                Block block = pair.block();
                if (block instanceof LiquidBlock) {
                    LiquidBlock liquidBlock = (LiquidBlock)block;
                    ingredients.add(this.fluidHelper.create((Holder)liquidBlock.fluid.builtInRegistryHolder(), 1000L));
                    continue;
                }
                BlockState state = pair.block().defaultBlockState();
                if (pair.properties().isPresent()) {
                    for (Map.Entry propertyEntry : ((Reference2ObjectArrayMap)pair.properties().get()).entrySet()) {
                        state = BlockStateRecipeUtil.setHelper((Map.Entry)propertyEntry, (BlockState)state);
                    }
                }
                stack = (stack = pair.block().getCloneItemStack((LevelReader)Minecraft.getInstance().level, BlockPos.ZERO, state)).isEmpty() ? new ItemStack((ItemLike)Blocks.STONE) : stack;
                ingredients.add(stack);
            }
        }
        return ingredients;
    }

    public void draw(R recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (((AbstractPlacementBanRecipe)recipe).getBypassBlock().isEmpty() || ((AbstractPlacementBanRecipe)recipe).getBypassBlock().get().isEmpty()) {
            this.slot.draw(guiGraphics, 49, 0);
        } else {
            this.slot.draw(guiGraphics);
            this.slot.draw(guiGraphics, 98, 0);
            String text = Translator.translateToLocalFormatted((String)"gui.aether.jei.bypass", (Object[])new Object[0]);
            Font font = Minecraft.getInstance().font;
            guiGraphics.drawString(font, text, 24, 5, -8355712);
        }
    }

    protected void populateAdditionalInformation(R recipe, List<Component> tooltip) {
        if (Minecraft.getInstance().level != null) {
            this.populateBiomeInformation(((AbstractPlacementBanRecipe)recipe).getBiome().left().orElse(null), ((AbstractPlacementBanRecipe)recipe).getBiome().right().orElse(null), tooltip);
        }
    }
}

