/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.loot;

import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.combat.AetherItemTiers;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class HolySwordItem
extends SwordItem {
    public HolySwordItem() {
        super((Tier)AetherItemTiers.HOLY, new Item.Properties().rarity(AetherItems.AETHER_LOOT).attributes(SwordItem.createAttributes((Tier)AetherItemTiers.HOLY, (int)3, (float)-2.4f)));
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (EquipmentUtil.isFullStrength(attacker) && (target.getType().is(EntityTypeTags.UNDEAD) || target.isInvertedHealAndHarm())) {
            stack.hurtAndBreak(10, attacker, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        float damage = event.getNewDamage();
        if (HolySwordItem.canPerformAbility(target, damageSource)) {
            ItemStack itemStack = target.getMainHandItem();
            float bonus = 8.25f;
            int smiteModifier = itemStack.getEnchantmentLevel(target.level().holderOrThrow(Enchantments.SMITE));
            if (smiteModifier > 0) {
                bonus += (float)smiteModifier * 2.5f;
            }
            event.setNewDamage(damage + bonus);
        }
    }

    private static boolean canPerformAbility(LivingEntity target, DamageSource source) {
        LivingEntity attacker;
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity && EquipmentUtil.isFullStrength(attacker = (LivingEntity)entity) && (target.getType().is(EntityTypeTags.UNDEAD) || target.isInvertedHealAndHarm())) {
            return attacker.getMainHandItem().is((Item)AetherItems.HOLY_SWORD.get());
        }
        return false;
    }
}

