/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.loot.functions;

import com.aetherteam.aether.loot.functions.AetherLootFunctions;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class SpawnXP
extends LootItemConditionalFunction {
    public static final MapCodec<SpawnXP> CODEC = RecordCodecBuilder.mapCodec(instance -> SpawnXP.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SpawnXP::new));

    protected SpawnXP(List<LootItemCondition> conditions) {
        super(conditions);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        ServerLevel serverLevel = context.getLevel();
        Vec3 originVec = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        if (originVec != null) {
            int i;
            for (int randomNumber = (int)(4.0 * serverLevel.getRandom().nextDouble() + 6.0); randomNumber > 0; randomNumber -= i) {
                i = ExperienceOrb.getExperienceValue((int)randomNumber);
                serverLevel.addFreshEntity((Entity)new ExperienceOrb((Level)serverLevel, originVec.x(), originVec.y(), originVec.z(), i));
            }
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(SpawnXP::new);
    }

    public LootItemFunctionType<SpawnXP> getType() {
        return (LootItemFunctionType)AetherLootFunctions.SPAWN_XP.get();
    }
}

