/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.entity.NpcDialogue;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NpcPlayerInteractPacket(int entityID, byte interactionID) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<NpcPlayerInteractPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"set_npc_interaction_action"));
    public static final StreamCodec<RegistryFriendlyByteBuf, NpcPlayerInteractPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, NpcPlayerInteractPacket::entityID, (StreamCodec)ByteBufCodecs.BYTE, NpcPlayerInteractPacket::interactionID, NpcPlayerInteractPacket::new);

    public CustomPacketPayload.Type<NpcPlayerInteractPacket> type() {
        return TYPE;
    }

    public static void execute(NpcPlayerInteractPacket payload, IPayloadContext context) {
        Entity entity;
        Player playerEntity = context.player();
        if (playerEntity.getServer() != null && (entity = playerEntity.level().getEntity(payload.entityID())) instanceof NpcDialogue) {
            NpcDialogue npc = (NpcDialogue)entity;
            npc.handleNpcInteraction(playerEntity, payload.interactionID());
        }
    }
}

