/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.perk;

import com.aetherteam.aether.Aether;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;

public class CustomizationsOptions {
    private static final File CUSTOMIZATIONS_FILE = new File(Aether.DIRECTORY.toString(), "aether_customizations.txt");
    private final LinkedHashMap<String, Object> customizations = new LinkedHashMap();
    public static final CustomizationsOptions INSTANCE = new CustomizationsOptions();

    public CustomizationsOptions() {
        if (CUSTOMIZATIONS_FILE.exists()) {
            this.load();
        } else {
            this.customizations.put("haloEnabled", true);
            this.customizations.put("haloColor", "");
            this.customizations.put("developerGlowEnabled", false);
            this.customizations.put("developerGlowColor", "");
            this.customizations.put("moaSkin", "");
            this.save();
        }
    }

    public void load() {
        try {
            Scanner reader = new Scanner(CUSTOMIZATIONS_FILE);
            while (reader.hasNextLine()) {
                String line = reader.nextLine();
                String[] split = line.split(":");
                if (split.length <= 1) continue;
                String key = split[0];
                String value = split[1];
                if (Boolean.parseBoolean(value)) {
                    this.set(key, Boolean.valueOf(value));
                    continue;
                }
                this.set(key, value);
            }
        }
        catch (IOException exception) {
            Aether.LOGGER.warn("Failed to load Aether perk customizations: ", (Throwable)exception);
        }
    }

    public void save() {
        try {
            FileWriter writer = new FileWriter(CUSTOMIZATIONS_FILE);
            for (Map.Entry<String, Object> entry : this.customizations.entrySet()) {
                writer.write(entry.getKey() + ":" + String.valueOf(entry.getValue()) + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (IOException exception) {
            Aether.LOGGER.warn("Failed to save Aether perk customizations: ", (Throwable)exception);
        }
    }

    public boolean isHaloEnabled() {
        Object value = this.get("haloEnabled");
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        return false;
    }

    public void setIsHaloEnabled(boolean value) {
        this.set("haloEnabled", value);
    }

    public String getHaloHex() {
        Object value = this.get("haloColor");
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        return "";
    }

    public void setHaloColor(String value) {
        this.set("haloColor", value);
    }

    public boolean isDeveloperGlowEnabled() {
        Object value = this.get("developerGlowEnabled");
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool;
        }
        return false;
    }

    public void setIsDeveloperGlowEnabled(boolean value) {
        this.set("developerGlowEnabled", value);
    }

    public String getDeveloperGlowHex() {
        Object value = this.get("developerGlowColor");
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        return "";
    }

    public void setDeveloperGlowColor(String value) {
        this.set("developerGlowColor", value);
    }

    public String getMoaSkin() {
        Object value = this.get("moaSkin");
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        return "";
    }

    public void setMoaSkin(String value) {
        this.set("moaSkin", value);
    }

    public Object get(String string) {
        return this.customizations.get(string);
    }

    public void set(String string, Object object) {
        if (this.customizations.containsKey(string)) {
            this.customizations.replace(string, object);
        } else {
            this.customizations.put(string, object);
        }
    }
}

