/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import com.connectivity.networkstats.MalformedTrafficTracker;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public abstract class ConnectionMixin {
    @Shadow
    @Nullable
    private volatile PacketListener packetListener;
    @Shadow
    @Nullable
    private DisconnectionDetails disconnectionDetails;
    @Unique
    private int counter = 0;
    @Unique
    private Packet<?> lastPacket = null;

    @Shadow
    public abstract void disconnect(Component var1);

    @Inject(method={"exceptionCaught"}, at={@At(value="HEAD")})
    public void on(ChannelHandlerContext context, Throwable throwable, CallbackInfo ci) {
        if (!(throwable instanceof ClosedChannelException)) {
            MalformedTrafficTracker.recordError(context);
        }
        ++this.counter;
        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages && this.disconnectionDetails == null && !(throwable instanceof ClosedChannelException)) {
            PacketListener packetListener = this.packetListener;
            if (packetListener instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl serverGamePacketListener = (ServerGamePacketListenerImpl)packetListener;
                Connectivity.LOGGER.warn("Network error in:" + context.name() + " for player:" + serverGamePacketListener.getPlayer().getName().getString(), throwable);
            } else {
                Connectivity.LOGGER.warn("Network error in:" + context.name() + " with:" + String.valueOf(this.packetListener), throwable);
            }
            if (this.lastPacket != null) {
                PacketLogging.logPacket(this.lastPacket, "Printing packet to send:");
                this.lastPacket = null;
            }
        }
        if (this.counter >= 20) {
            String temp = "unknown";
            PacketListener packetListener = this.packetListener;
            if (packetListener instanceof ServerGamePacketListenerImpl) {
                ServerGamePacketListenerImpl serverGamePacketListener = (ServerGamePacketListenerImpl)packetListener;
                temp = serverGamePacketListener.getPlayer().getName().getString();
            }
            String name = temp;
            this.counter = -100000;
            this.disconnect((Component)Component.literal((String)"Too many network errors"));
            context.channel().disconnect().addListener(future -> {
                if (!future.isSuccess() && ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                    Connectivity.LOGGER.warn("Failed to disconnect channel for: " + name);
                }
                context.channel().deregister().addListener(dereFuture -> {
                    if (dereFuture.isSuccess()) {
                        if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                            Connectivity.LOGGER.warn("Channel deregistered for: " + name);
                        }
                    } else if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                        Connectivity.LOGGER.warn("Failed to deregister channel for: " + name);
                    }
                    context.channel().close().addListener(closeFuture -> {
                        if (closeFuture.isSuccess()) {
                            if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                                Connectivity.LOGGER.warn("Channel closed for: " + name);
                            }
                        } else if (((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                            Connectivity.LOGGER.warn("Failed to close channel for: " + name);
                        }
                        for (String handler : context.channel().pipeline().names()) {
                            try {
                                context.channel().pipeline().remove(handler);
                            }
                            catch (Throwable throwable) {}
                        }
                    });
                });
            });
        }
    }

    @Redirect(method={"disconnect(Lnet/minecraft/network/DisconnectionDetails;)V"}, at=@At(value="INVOKE", target="Lio/netty/channel/ChannelFuture;awaitUninterruptibly()Lio/netty/channel/ChannelFuture;"))
    private ChannelFuture onWait(ChannelFuture instance) {
        try {
            instance.await(10L, TimeUnit.SECONDS);
            return null;
        }
        catch (InterruptedException e) {
            Connectivity.LOGGER.warn("Interrupted thread:" + String.valueOf(Thread.currentThread()));
            return null;
        }
    }

    @Inject(method={"doSendPacket"}, at={@At(value="HEAD")})
    private void onSend(Packet<?> p_243260_, PacketSendListener p_243290_, boolean p_294125_, CallbackInfo ci) {
        this.lastPacket = p_243260_;
    }

    @Inject(method={"doSendPacket"}, at={@At(value="RETURN")})
    private void afterSend(Packet<?> p_243260_, PacketSendListener p_243290_, boolean p_294125_, CallbackInfo ci) {
        this.lastPacket = null;
    }
}

