/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget.input;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

@Beta
public enum MouseInput {
    LEFT_CLICK(0),
    MIDDLE_CLICK(2),
    RIGHT_CLICK(1);

    private static final Map<Integer, MouseInput> BUTTON_TO_INPUT;
    private final int button;

    private MouseInput(int button) {
        this.button = button;
    }

    @Nullable
    public static MouseInput fromButton(int button) {
        return BUTTON_TO_INPUT.get(button);
    }

    public int button() {
        return this.button;
    }

    static {
        BUTTON_TO_INPUT = Stream.of(MouseInput.values()).collect(Collectors.toUnmodifiableMap(MouseInput::button, Function.identity()));
    }
}

