/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import glitchcore.event.EventManager;
import glitchcore.event.RegistryEvent;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class RegistryHelper
implements Consumer<RegistryEvent> {
    private final Multimap<ResourceKey<? extends Registry<?>>, Registrar<?>> registrars = ArrayListMultimap.create();

    private RegistryHelper() {
        EventManager.addListener(this);
    }

    public static RegistryHelper create() {
        return new RegistryHelper();
    }

    public <T> void addRegistrar(ResourceKey<? extends Registry<T>> registry, Registrar<T> registrar) {
        this.registrars.put(registry, registrar);
    }

    @Override
    public void accept(RegistryEvent registryEvent) {
        this.registrars.get(registryEvent.getRegistryKey()).forEach(registrar -> registrar.registerAll(registryEvent::register));
    }

    public static interface Registrar<T> {
        public void registerAll(BiConsumer<ResourceLocation, T> var1);
    }
}

