/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.block;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pixelbank.burnt.init.BurntModBlocks;
import net.pixelbank.burnt.procedures.BrokenBlazingLogTickProcedure;
import net.pixelbank.burnt.procedures.BrokenBurntLogsSnowballProcedure;
import net.pixelbank.burnt.procedures.BurntBlockDestroyedProcedure;
import net.pixelbank.burnt.procedures.BurntLogsFireDamageProcedure;
import net.pixelbank.burnt.procedures.SmolderLogsParticlesProcedure;

public class BrokenBlazingLogBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)1);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)1);

    public BrokenBlazingLogBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.FIRE).sound(SoundType.WOOD).strength(2.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 15;
                }
                return 15;
            }
        }.getLightLevel()).noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidstate) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return switch ((Direction.Axis)state.getValue(AXIS)) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> Shapes.or((VoxelShape)BrokenBlazingLogBlock.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BrokenBlazingLogBlock.box((double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0, (double)16.0), BrokenBlazingLogBlock.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)9.0)});
                case Direction.Axis.Y -> Shapes.or((VoxelShape)BrokenBlazingLogBlock.box((double)7.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[]{BrokenBlazingLogBlock.box((double)9.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), BrokenBlazingLogBlock.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0)});
                case Direction.Axis.Z -> Shapes.or((VoxelShape)BrokenBlazingLogBlock.box((double)7.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BrokenBlazingLogBlock.box((double)9.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), BrokenBlazingLogBlock.box((double)0.0, (double)7.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0)});
            };
        }
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> Shapes.or((VoxelShape)BrokenBlazingLogBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)9.0), (VoxelShape[])new VoxelShape[]{BrokenBlazingLogBlock.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)7.0), BrokenBlazingLogBlock.box((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)16.0, (double)16.0)});
            case Direction.Axis.Y -> Shapes.or((VoxelShape)BrokenBlazingLogBlock.box((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[]{BrokenBlazingLogBlock.box((double)0.0, (double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0), BrokenBlazingLogBlock.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)16.0)});
            case Direction.Axis.Z -> Shapes.or((VoxelShape)BrokenBlazingLogBlock.box((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)7.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BrokenBlazingLogBlock.box((double)0.0, (double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0), BrokenBlazingLogBlock.box((double)7.0, (double)7.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS, STAGE, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(AXIS, (Comparable)context.getClickedFace().getAxis())).setValue((Property)STAGE, (Comparable)Integer.valueOf(0));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            if (state.getValue(AXIS) == Direction.Axis.X) {
                return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
            }
            if (state.getValue(AXIS) == Direction.Axis.Z) {
                return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
            }
        }
        return state;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BurntModBlocks.BROKEN_BURNT_LOG.get());
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.DANGER_FIRE;
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 30);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        BrokenBlazingLogTickProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 30);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        LocalPlayer entity = Minecraft.getInstance().player;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        SmolderLogsParticlesProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        BurntBlockDestroyedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
        return retval;
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        BurntLogsFireDamageProcedure.execute((LevelAccessor)world, blockstate, entity);
    }

    public void onProjectileHit(Level world, BlockState blockstate, BlockHitResult hit, Projectile entity) {
        BrokenBurntLogsSnowballProcedure.execute((LevelAccessor)world, hit.getBlockPos().getX(), hit.getBlockPos().getY(), hit.getBlockPos().getZ(), (Entity)entity);
    }
}

