/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.block;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pixelbank.burnt.procedures.TarBubblesParticlesProcedure;
import net.pixelbank.burnt.procedures.TarCauldronOnTickUpdateProcedure;

public class TarCauldronBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)3);
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)3);

    public TarCauldronBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 3) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(3)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return Shapes.or((VoxelShape)TarCauldronBlock.box((double)0.0, (double)3.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TarCauldronBlock.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), TarCauldronBlock.box((double)14.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), TarCauldronBlock.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), TarCauldronBlock.box((double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)2.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)4.0), TarCauldronBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), TarCauldronBlock.box((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)4.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)12.0, (double)2.0, (double)3.0, (double)14.0), TarCauldronBlock.box((double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), TarCauldronBlock.box((double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0, (double)14.0), TarCauldronBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0)});
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 2) {
            return Shapes.or((VoxelShape)TarCauldronBlock.box((double)0.0, (double)3.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TarCauldronBlock.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), TarCauldronBlock.box((double)14.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), TarCauldronBlock.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), TarCauldronBlock.box((double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)2.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)4.0), TarCauldronBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), TarCauldronBlock.box((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)4.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)12.0, (double)2.0, (double)3.0, (double)14.0), TarCauldronBlock.box((double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), TarCauldronBlock.box((double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0, (double)14.0), TarCauldronBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)});
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 3) {
            return Shapes.or((VoxelShape)TarCauldronBlock.box((double)0.0, (double)3.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TarCauldronBlock.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), TarCauldronBlock.box((double)14.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), TarCauldronBlock.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), TarCauldronBlock.box((double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)2.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)4.0), TarCauldronBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), TarCauldronBlock.box((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)4.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)12.0, (double)2.0, (double)3.0, (double)14.0), TarCauldronBlock.box((double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), TarCauldronBlock.box((double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0, (double)14.0), TarCauldronBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0)});
        }
        return Shapes.or((VoxelShape)TarCauldronBlock.box((double)0.0, (double)3.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{TarCauldronBlock.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), TarCauldronBlock.box((double)14.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), TarCauldronBlock.box((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0), TarCauldronBlock.box((double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)2.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)3.0, (double)4.0), TarCauldronBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)2.0), TarCauldronBlock.box((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)3.0, (double)4.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0, (double)16.0), TarCauldronBlock.box((double)0.0, (double)0.0, (double)12.0, (double)2.0, (double)3.0, (double)14.0), TarCauldronBlock.box((double)12.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (double)16.0), TarCauldronBlock.box((double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0, (double)14.0), TarCauldronBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0)});
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEVEL, BLOCKSTATE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)LEVEL, (Comparable)Integer.valueOf(3));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.CAULDRON);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 1);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        TarCauldronOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
        world.scheduleTick(pos, (Block)this, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        LocalPlayer entity = Minecraft.getInstance().player;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        TarBubblesParticlesProcedure.execute((LevelAccessor)world, x, y, z);
    }
}

