/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.fluid;

import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.pixelbank.burnt.init.BurntModBlocks;
import net.pixelbank.burnt.init.BurntModFluidTypes;
import net.pixelbank.burnt.init.BurntModFluids;

public abstract class FlamingTarFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)BurntModFluidTypes.FLAMING_TAR_TYPE.get(), () -> (Fluid)BurntModFluids.FLAMING_TAR.get(), () -> (Fluid)BurntModFluids.FLOWING_FLAMING_TAR.get()).explosionResistance(100.0f).levelDecreasePerBlock(3).slopeFindDistance(2).block(() -> (LiquidBlock)BurntModBlocks.FLAMING_TAR.get());

    private FlamingTarFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends FlamingTarFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends FlamingTarFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

