/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.fluid.types;

import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import net.pixelbank.burnt.init.BurntModFluidTypes;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GeyserWaterFluidType
extends FluidType {
    public GeyserWaterFluidType() {
        super(FluidType.Properties.create().fallDistanceModifier(0.0f).canExtinguish(true).supportsBoating(true).canHydrate(true).motionScale(0.007).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH));
    }

    @SubscribeEvent
    public static void registerFluidTypeExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL_TEXTURE = ResourceLocation.parse((String)"minecraft:block/water_still");
            private static final ResourceLocation FLOWING_TEXTURE = ResourceLocation.parse((String)"minecraft:block/water_flow");

            public ResourceLocation getStillTexture() {
                return STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOWING_TEXTURE;
            }

            public int getTintColor() {
                return -13083194;
            }

            public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
                return BiomeColors.getAverageWaterColor((BlockAndTintGetter)world, (BlockPos)pos) | 0xFF000000;
            }
        }, new FluidType[]{(FluidType)BurntModFluidTypes.GEYSER_WATER_TYPE.get()});
    }
}

