/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.pixelbank.burnt.entity.BlazeArrowEntity;
import net.pixelbank.burnt.entity.BurntForestSpawnerEntity;
import net.pixelbank.burnt.entity.FallingSlabEntity;
import net.pixelbank.burnt.entity.FireDevilEntity;
import net.pixelbank.burnt.entity.FireballEntity;
import net.pixelbank.burnt.entity.FlintTrailEntity;
import net.pixelbank.burnt.entity.GeyserEntity;
import net.pixelbank.burnt.entity.GraveSpawnerEntity;
import net.pixelbank.burnt.entity.LitMatchEntity;
import net.pixelbank.burnt.entity.LitMolotovProjectileEntity;
import net.pixelbank.burnt.entity.MolotovProjectileEntity;
import net.pixelbank.burnt.entity.MolotovTarEntity;
import net.pixelbank.burnt.entity.SmokeEntity;
import net.pixelbank.burnt.entity.SoulArrowEntity;
import net.pixelbank.burnt.entity.SoulSparkEntity;
import net.pixelbank.burnt.entity.SoulSpawnerEntity;
import net.pixelbank.burnt.entity.SparkEntity;
import net.pixelbank.burnt.entity.SprayEntity;
import net.pixelbank.burnt.entity.TombSpawnerEntity;
import net.pixelbank.burnt.entity.VolcanoEntity;
import net.pixelbank.burnt.entity.WispEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class BurntModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"burnt");
    public static final DeferredHolder<EntityType<?>, EntityType<SparkEntity>> SPARK = BurntModEntities.register("spark", EntityType.Builder.of(SparkEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(0).setUpdateInterval(3).sized(0.1f, 0.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<SprayEntity>> SPRAY = BurntModEntities.register("spray", EntityType.Builder.of(SprayEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<SoulSparkEntity>> SOUL_SPARK = BurntModEntities.register("soul_spark", EntityType.Builder.of(SoulSparkEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(0).setUpdateInterval(3).sized(0.1f, 0.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<BurntForestSpawnerEntity>> BURNT_FOREST_SPAWNER = BurntModEntities.register("burnt_forest_spawner", EntityType.Builder.of(BurntForestSpawnerEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(24).setUpdateInterval(3).fireImmune().sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<GraveSpawnerEntity>> GRAVE_SPAWNER = BurntModEntities.register("grave_spawner", EntityType.Builder.of(GraveSpawnerEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(24).setUpdateInterval(3).sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<TombSpawnerEntity>> TOMB_SPAWNER = BurntModEntities.register("tomb_spawner", EntityType.Builder.of(TombSpawnerEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(24).setUpdateInterval(3).sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<SoulSpawnerEntity>> SOUL_SPAWNER = BurntModEntities.register("soul_spawner", EntityType.Builder.of(SoulSpawnerEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(24).setUpdateInterval(3).sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<WispEntity>> WISP = BurntModEntities.register("wisp", EntityType.Builder.of(WispEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<FireDevilEntity>> FIRE_DEVIL = BurntModEntities.register("fire_devil", EntityType.Builder.of(FireDevilEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<FlintTrailEntity>> FLINT_TRAIL = BurntModEntities.register("flint_trail", EntityType.Builder.of(FlintTrailEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<SmokeEntity>> SMOKE = BurntModEntities.register("smoke", EntityType.Builder.of(SmokeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.0f, 0.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlazeArrowEntity>> BLAZE_ARROW = BurntModEntities.register("blaze_arrow", EntityType.Builder.of(BlazeArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.2f, 0.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<SoulArrowEntity>> SOUL_ARROW = BurntModEntities.register("soul_arrow", EntityType.Builder.of(SoulArrowEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.2f, 0.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<GeyserEntity>> GEYSER = BurntModEntities.register("geyser", EntityType.Builder.of(GeyserEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.4f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<VolcanoEntity>> VOLCANO = BurntModEntities.register("volcano", EntityType.Builder.of(VolcanoEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.0f, 0.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<FireballEntity>> FIREBALL = BurntModEntities.register("fireball", EntityType.Builder.of(FireballEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<LitMolotovProjectileEntity>> LIT_MOLOTOV_PROJECTILE = BurntModEntities.register("lit_molotov_projectile", EntityType.Builder.of(LitMolotovProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.2f, 0.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<MolotovProjectileEntity>> MOLOTOV_PROJECTILE = BurntModEntities.register("molotov_projectile", EntityType.Builder.of(MolotovProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.2f, 0.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<LitMatchEntity>> LIT_MATCH = BurntModEntities.register("lit_match", EntityType.Builder.of(LitMatchEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<MolotovTarEntity>> MOLOTOV_TAR = BurntModEntities.register("molotov_tar", EntityType.Builder.of(MolotovTarEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<FallingSlabEntity>> FALLING_SLAB = BurntModEntities.register("falling_slab", EntityType.Builder.of(FallingSlabEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SparkEntity.init(event);
        SoulSparkEntity.init(event);
        BurntForestSpawnerEntity.init(event);
        GraveSpawnerEntity.init(event);
        TombSpawnerEntity.init(event);
        SoulSpawnerEntity.init(event);
        WispEntity.init(event);
        FireDevilEntity.init(event);
        SmokeEntity.init(event);
        GeyserEntity.init(event);
        VolcanoEntity.init(event);
        MolotovTarEntity.init(event);
        FallingSlabEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SPARK.get(), SparkEntity.createAttributes().build());
        event.put((EntityType)SOUL_SPARK.get(), SoulSparkEntity.createAttributes().build());
        event.put((EntityType)BURNT_FOREST_SPAWNER.get(), BurntForestSpawnerEntity.createAttributes().build());
        event.put((EntityType)GRAVE_SPAWNER.get(), GraveSpawnerEntity.createAttributes().build());
        event.put((EntityType)TOMB_SPAWNER.get(), TombSpawnerEntity.createAttributes().build());
        event.put((EntityType)SOUL_SPAWNER.get(), SoulSpawnerEntity.createAttributes().build());
        event.put((EntityType)WISP.get(), WispEntity.createAttributes().build());
        event.put((EntityType)FIRE_DEVIL.get(), FireDevilEntity.createAttributes().build());
        event.put((EntityType)SMOKE.get(), SmokeEntity.createAttributes().build());
        event.put((EntityType)GEYSER.get(), GeyserEntity.createAttributes().build());
        event.put((EntityType)VOLCANO.get(), VolcanoEntity.createAttributes().build());
        event.put((EntityType)MOLOTOV_TAR.get(), MolotovTarEntity.createAttributes().build());
        event.put((EntityType)FALLING_SLAB.get(), FallingSlabEntity.createAttributes().build());
    }
}

