/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.item;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.pixelbank.burnt.procedures.ExtinguisherOffLogicProcedure;
import net.pixelbank.burnt.procedures.ExtinguisherOnLogicProcedure;
import net.pixelbank.burnt.procedures.ExtinguisherSprayingProcedure;

public class ExtinguisherItem
extends Item {
    public ExtinguisherItem() {
        super(new Item.Properties().durability(1000).fireResistant().rarity(Rarity.UNCOMMON));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 1000;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        ExtinguisherOnLogicProcedure.execute((Entity)entity);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        ExtinguisherOffLogicProcedure.execute((Entity)entity);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            ExtinguisherSprayingProcedure.execute((LevelAccessor)world, entity, itemstack);
        }
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        ExtinguisherOffLogicProcedure.execute((Entity)entity);
    }
}

