/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.item;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.pixelbank.burnt.procedures.FlintBowDrawTimerProcedure;
import net.pixelbank.burnt.procedures.FlintBowItemInInventoryTickProcedure;
import net.pixelbank.burnt.procedures.FlintBowOffLogicProcedure;
import net.pixelbank.burnt.procedures.FlintBowOnLogicProcedure;

public class FlintBowItem
extends Item {
    public FlintBowItem() {
        super(new Item.Properties().durability(64).fireResistant().rarity(Rarity.UNCOMMON));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getEnchantmentValue() {
        return 14;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 64000;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        FlintBowOnLogicProcedure.execute((Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            FlintBowDrawTimerProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
        }
        FlintBowItemInInventoryTickProcedure.execute((LevelAccessor)world, entity, itemstack);
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        FlintBowOffLogicProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
    }
}

