/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.network;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.pixelbank.burnt.BurntMod;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class BurntModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"burnt");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BurntMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        BurntMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"burnt", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"burnt", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean arrowFired = false;
        public boolean extinguisherOn = false;
        public boolean flintDrawn = false;
        public boolean playerSoul = false;
        public boolean soulDrawn = false;
        public boolean blazeDrawn = false;
        public boolean gasMaskOn = false;
        public double facePlayer = 0.0;
        public double PlayerTickDelay = 0.0;
        public double fireProof = 0.0;
        public double matchBurn = 0.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("arrowFired", this.arrowFired);
            nbt.putBoolean("extinguisherOn", this.extinguisherOn);
            nbt.putBoolean("flintDrawn", this.flintDrawn);
            nbt.putBoolean("playerSoul", this.playerSoul);
            nbt.putBoolean("soulDrawn", this.soulDrawn);
            nbt.putBoolean("blazeDrawn", this.blazeDrawn);
            nbt.putBoolean("gasMaskOn", this.gasMaskOn);
            nbt.putDouble("facePlayer", this.facePlayer);
            nbt.putDouble("PlayerTickDelay", this.PlayerTickDelay);
            nbt.putDouble("fireProof", this.fireProof);
            nbt.putDouble("matchBurn", this.matchBurn);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.arrowFired = nbt.getBoolean("arrowFired");
            this.extinguisherOn = nbt.getBoolean("extinguisherOn");
            this.flintDrawn = nbt.getBoolean("flintDrawn");
            this.playerSoul = nbt.getBoolean("playerSoul");
            this.soulDrawn = nbt.getBoolean("soulDrawn");
            this.blazeDrawn = nbt.getBoolean("blazeDrawn");
            this.gasMaskOn = nbt.getBoolean("gasMaskOn");
            this.facePlayer = nbt.getDouble("facePlayer");
            this.PlayerTickDelay = nbt.getDouble("PlayerTickDelay");
            this.fireProof = nbt.getDouble("fireProof");
            this.matchBurn = nbt.getDouble("matchBurn");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "burnt_mapvars";
        public boolean burntOn = true;
        public boolean biomeSpecific = false;
        public boolean rainExtinguish = true;
        public boolean collapseOn = true;
        public boolean flameParticles = true;
        public boolean ashParticles = true;
        public boolean burnDamage = true;
        public boolean smokeParticles = true;
        public boolean sootOn = true;
        public boolean vanillaCatch = true;
        public boolean craftedBlocksBurn = true;
        public boolean fireDevil = true;
        public boolean wisp = true;
        public boolean woolBurns = true;
        public boolean flameBowOn = true;
        public boolean fireAspectOn = false;
        public boolean structuresOn = true;
        public boolean lightningCatch = false;
        public boolean smokeFogParticles = true;
        public boolean chokingOn = true;
        public boolean burnChestContents = true;
        public boolean toxicSmoke = true;
        public boolean dynamicFog = true;
        public double fireSpeed = 5.0;
        public double fireSpread = 6.0;
        public double playerDistance = 0.0;
        public double grassRecovery = 3.0;
        public double particle_distance = 160.0;
        public double smokeCount = 0.0;
        public double burnSpeed = 50.0;
        public double burnSpread = 50.0;
        public double groundSpread = 50.0;
        public boolean soulFireOverworld = true;
        public double burning = 0.0;
        public boolean overworldOnly = true;
        public double chanceCollapse = 100.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.burntOn = nbt.getBoolean("burntOn");
            this.biomeSpecific = nbt.getBoolean("biomeSpecific");
            this.rainExtinguish = nbt.getBoolean("rainExtinguish");
            this.collapseOn = nbt.getBoolean("collapseOn");
            this.flameParticles = nbt.getBoolean("flameParticles");
            this.ashParticles = nbt.getBoolean("ashParticles");
            this.burnDamage = nbt.getBoolean("burnDamage");
            this.smokeParticles = nbt.getBoolean("smokeParticles");
            this.sootOn = nbt.getBoolean("sootOn");
            this.vanillaCatch = nbt.getBoolean("vanillaCatch");
            this.craftedBlocksBurn = nbt.getBoolean("craftedBlocksBurn");
            this.fireDevil = nbt.getBoolean("fireDevil");
            this.wisp = nbt.getBoolean("wisp");
            this.woolBurns = nbt.getBoolean("woolBurns");
            this.flameBowOn = nbt.getBoolean("flameBowOn");
            this.fireAspectOn = nbt.getBoolean("fireAspectOn");
            this.structuresOn = nbt.getBoolean("structuresOn");
            this.lightningCatch = nbt.getBoolean("lightningCatch");
            this.smokeFogParticles = nbt.getBoolean("smokeFogParticles");
            this.chokingOn = nbt.getBoolean("chokingOn");
            this.burnChestContents = nbt.getBoolean("burnChestContents");
            this.toxicSmoke = nbt.getBoolean("toxicSmoke");
            this.dynamicFog = nbt.getBoolean("dynamicFog");
            this.fireSpeed = nbt.getDouble("fireSpeed");
            this.fireSpread = nbt.getDouble("fireSpread");
            this.playerDistance = nbt.getDouble("playerDistance");
            this.grassRecovery = nbt.getDouble("grassRecovery");
            this.particle_distance = nbt.getDouble("particle_distance");
            this.smokeCount = nbt.getDouble("smokeCount");
            this.burnSpeed = nbt.getDouble("burnSpeed");
            this.burnSpread = nbt.getDouble("burnSpread");
            this.groundSpread = nbt.getDouble("groundSpread");
            this.soulFireOverworld = nbt.getBoolean("soulFireOverworld");
            this.burning = nbt.getDouble("burning");
            this.overworldOnly = nbt.getBoolean("overworldOnly");
            this.chanceCollapse = nbt.getDouble("chanceCollapse");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("burntOn", this.burntOn);
            nbt.putBoolean("biomeSpecific", this.biomeSpecific);
            nbt.putBoolean("rainExtinguish", this.rainExtinguish);
            nbt.putBoolean("collapseOn", this.collapseOn);
            nbt.putBoolean("flameParticles", this.flameParticles);
            nbt.putBoolean("ashParticles", this.ashParticles);
            nbt.putBoolean("burnDamage", this.burnDamage);
            nbt.putBoolean("smokeParticles", this.smokeParticles);
            nbt.putBoolean("sootOn", this.sootOn);
            nbt.putBoolean("vanillaCatch", this.vanillaCatch);
            nbt.putBoolean("craftedBlocksBurn", this.craftedBlocksBurn);
            nbt.putBoolean("fireDevil", this.fireDevil);
            nbt.putBoolean("wisp", this.wisp);
            nbt.putBoolean("woolBurns", this.woolBurns);
            nbt.putBoolean("flameBowOn", this.flameBowOn);
            nbt.putBoolean("fireAspectOn", this.fireAspectOn);
            nbt.putBoolean("structuresOn", this.structuresOn);
            nbt.putBoolean("lightningCatch", this.lightningCatch);
            nbt.putBoolean("smokeFogParticles", this.smokeFogParticles);
            nbt.putBoolean("chokingOn", this.chokingOn);
            nbt.putBoolean("burnChestContents", this.burnChestContents);
            nbt.putBoolean("toxicSmoke", this.toxicSmoke);
            nbt.putBoolean("dynamicFog", this.dynamicFog);
            nbt.putDouble("fireSpeed", this.fireSpeed);
            nbt.putDouble("fireSpread", this.fireSpread);
            nbt.putDouble("playerDistance", this.playerDistance);
            nbt.putDouble("grassRecovery", this.grassRecovery);
            nbt.putDouble("particle_distance", this.particle_distance);
            nbt.putDouble("smokeCount", this.smokeCount);
            nbt.putDouble("burnSpeed", this.burnSpeed);
            nbt.putDouble("burnSpread", this.burnSpread);
            nbt.putDouble("groundSpread", this.groundSpread);
            nbt.putBoolean("soulFireOverworld", this.soulFireOverworld);
            nbt.putDouble("burning", this.burning);
            nbt.putBoolean("overworldOnly", this.overworldOnly);
            nbt.putDouble("chanceCollapse", this.chanceCollapse);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "burnt_worldvars";
        public double fogDistance = 51.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.fogDistance = nbt.getDouble("fogDistance");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("fogDistance", this.fogDistance);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.arrowFired = original.arrowFired;
            clone.extinguisherOn = original.extinguisherOn;
            clone.flintDrawn = original.flintDrawn;
            clone.playerSoul = original.playerSoul;
            clone.soulDrawn = original.soulDrawn;
            clone.blazeDrawn = original.blazeDrawn;
            clone.gasMaskOn = original.gasMaskOn;
            clone.facePlayer = original.facePlayer;
            clone.PlayerTickDelay = original.PlayerTickDelay;
            clone.fireProof = original.fireProof;
            clone.matchBurn = original.matchBurn;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

