/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.block.entity;

import com.TBF.cattlestrophic.block.FeedingTroughBlock;
import com.TBF.cattlestrophic.block.ModBlocks;
import com.TBF.cattlestrophic.capability.AnimalDataCapability;
import com.TBF.cattlestrophic.capability.IAnimalData;
import com.TBF.cattlestrophic.config.ModConfig;
import com.TBF.cattlestrophic.screen.FeedingTroughScreenHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FeedingTroughBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
    private int feedingCooldown = 0;
    private int registrationCooldown = 0;
    private int animalsInRange = 0;
    private List<Animal> registeredAnimals = new ArrayList<Animal>();

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.FEEDING_TROUGH_BLOCK_ENTITY.get(), pos, state);
    }

    public int getFeedingCooldown() {
        return this.feedingCooldown;
    }

    public void setFeedingCooldown(int value) {
        this.feedingCooldown = value;
    }

    public List<Animal> getRegisteredAnimals() {
        if (this.registeredAnimals == null) {
            this.registeredAnimals = new ArrayList<Animal>();
        }
        return this.registeredAnimals;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public SimpleContainer getSimpleContainer() {
        SimpleContainer container = new SimpleContainer(this.inventory.size());
        for (int i = 0; i < this.inventory.size(); ++i) {
            container.setItem(i, (ItemStack)this.inventory.get(i));
        }
        return container;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.updateFilledState();
        }
    }

    private boolean isValidFoodForAnimal(Item item, Animal animal) {
        String[] acceptedFoods = ModConfig.getInstance().getAnimalSettings(animal.getType()).getAcceptedFoodItems();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)item).toString();
        return Arrays.asList(acceptedFoods).contains(itemId);
    }

    private int findFoodForAnimal(Animal animal) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.isEmpty() || !this.isValidFoodForAnimal(stack.getItem(), animal)) continue;
            return i;
        }
        return -1;
    }

    private boolean feedAnimal(Animal animal) {
        IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
        if (animalData == null) {
            return false;
        }
        AtomicBoolean fed = new AtomicBoolean(false);
        if (!animalData.isDomesticated()) {
            return false;
        }
        int feedingAmount = ModConfig.getInstance().getAnimalSettings(animal.getType()).getFeedingAmount(ModConfig.getInstance().getFeedingAmount());
        if (animalData.getHungerLevel() >= 100 - feedingAmount) {
            return false;
        }
        int foodSlot = this.findFoodForAnimal(animal);
        if (foodSlot >= 0) {
            ItemStack foodStack = (ItemStack)this.inventory.get(foodSlot);
            animalData.setHungerLevel(animalData.getHungerLevel() + feedingAmount);
            foodStack.setCount(foodStack.getCount() - 1);
            if (foodStack.getCount() == 0) {
                this.inventory.set(foodSlot, (Object)ItemStack.EMPTY);
            }
            fed.set(true);
        }
        return fed.get();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean hasItems() {
        return !this.isEmpty();
    }

    public static void tick(Level world, BlockPos pos, BlockState state, FeedingTroughBlockEntity blockEntity) {
        if (world.isClientSide || !ModConfig.getInstance().isModEnabled()) {
            return;
        }
        if (world.getGameTime() % 100L == 0L) {
            // empty if block
        }
        if (blockEntity.registrationCooldown > 0) {
            --blockEntity.registrationCooldown;
        }
        if (blockEntity.feedingCooldown > 0) {
            --blockEntity.feedingCooldown;
        }
        if (!blockEntity.hasItems()) {
            if (blockEntity.registeredAnimals != null && !blockEntity.registeredAnimals.isEmpty()) {
                blockEntity.registeredAnimals.clear();
                blockEntity.setChanged();
            }
            return;
        }
        int range = ModConfig.getInstance().getFeedingTroughRange();
        int maxAnimalsPerTrough = ModConfig.getInstance().getMaxAnimalsPerTrough();
        AABB box = new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate((double)range);
        List animalsInRange = world.getEntitiesOfClass(Animal.class, box);
        ArrayList<Animal> domesticatedAnimals = new ArrayList<Animal>();
        for (Animal animal : animalsInRange) {
            IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
            if (animalData == null || !animalData.isDomesticated()) continue;
            domesticatedAnimals.add(animal);
        }
        blockEntity.animalsInRange = domesticatedAnimals.size();
        if (domesticatedAnimals.isEmpty()) {
            return;
        }
        if (blockEntity.registrationCooldown <= 0) {
            FeedingTroughBlockEntity.updateRegisteredAnimals(blockEntity, domesticatedAnimals, maxAnimalsPerTrough);
            FeedingTroughBlockEntity.calculateRegistrationRefreshInterval(blockEntity);
        }
        if (blockEntity.feedingCooldown <= 0) {
            AtomicBoolean anyFed = new AtomicBoolean(false);
            for (Animal animal : blockEntity.getRegisteredAnimals()) {
                IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
                if (animalData == null) continue;
                int feedingAmount = ModConfig.getInstance().getAnimalSettings(animal.getType()).getFeedingAmount(ModConfig.getInstance().getFeedingAmount());
                if (animalData.getHungerLevel() >= 100 - feedingAmount || !blockEntity.feedAnimal(animal)) continue;
                anyFed.set(true);
            }
            if (anyFed.get()) {
                blockEntity.setChanged();
            }
            FeedingTroughBlockEntity.calculateNextFeedingTime(blockEntity);
        }
        blockEntity.updateFilledState();
    }

    private static void updateRegisteredAnimals(FeedingTroughBlockEntity blockEntity, List<Animal> nearbyAnimals, int maxAnimals) {
        if (blockEntity.registeredAnimals == null) {
            blockEntity.registeredAnimals = new ArrayList<Animal>();
        }
        blockEntity.registeredAnimals.removeIf(animal -> animal == null || animal.isRemoved() || animal.level() != blockEntity.getLevel() || animal.distanceToSqr((double)blockEntity.getBlockPos().getX() + 0.5, (double)blockEntity.getBlockPos().getY() + 0.5, (double)blockEntity.getBlockPos().getZ() + 0.5) > Math.pow(ModConfig.getInstance().getFeedingTroughRange(), 2.0));
        if (blockEntity.registeredAnimals.size() < maxAnimals) {
            ArrayList<Animal> unregisteredAnimals = new ArrayList<Animal>(nearbyAnimals);
            unregisteredAnimals.removeAll(blockEntity.registeredAnimals);
            if (!unregisteredAnimals.isEmpty()) {
                unregisteredAnimals.sort(Comparator.comparingDouble(animal -> animal.distanceToSqr((double)blockEntity.getBlockPos().getX() + 0.5, (double)blockEntity.getBlockPos().getY() + 0.5, (double)blockEntity.getBlockPos().getZ() + 0.5)));
                for (Animal animal2 : unregisteredAnimals) {
                    if (blockEntity.registeredAnimals.size() >= maxAnimals) break;
                    blockEntity.registeredAnimals.add(animal2);
                }
            }
        }
    }

    private static void calculateRegistrationRefreshInterval(FeedingTroughBlockEntity blockEntity) {
        int baseDepletionRate = ModConfig.getInstance().getHungerDepletionRate();
        int baseFeedingAmount = ModConfig.getInstance().getFeedingAmount();
        int totalDepletionRate = 0;
        int totalFeedingAmount = 0;
        int animalCount = 0;
        for (Animal animal : blockEntity.getRegisteredAnimals()) {
            int animalDepletionRate = ModConfig.getInstance().getAnimalSettings(animal.getType()).getHungerDepletionRate(baseDepletionRate);
            int animalFeedingAmount = ModConfig.getInstance().getAnimalSettings(animal.getType()).getFeedingAmount(baseFeedingAmount);
            totalDepletionRate += animalDepletionRate;
            totalFeedingAmount += animalFeedingAmount;
            ++animalCount;
        }
        int avgDepletionRate = animalCount > 0 ? totalDepletionRate / animalCount : baseDepletionRate;
        int avgFeedingAmount = animalCount > 0 ? totalFeedingAmount / animalCount : baseFeedingAmount;
        double starvationTime = (double)avgDepletionRate * ((double)avgFeedingAmount / 100.0);
        int registrationInterval = (int)(starvationTime * 0.75);
        blockEntity.registrationCooldown = registrationInterval = Math.max(100, registrationInterval);
    }

    private static void calculateNextFeedingTime(FeedingTroughBlockEntity blockEntity) {
        int baseDepletionRate = ModConfig.getInstance().getHungerDepletionRate();
        int feedingInterval = baseDepletionRate / 4;
        if (blockEntity.registeredAnimals != null && !blockEntity.registeredAnimals.isEmpty()) {
            int totalDepletionRate = 0;
            int animalCount = 0;
            for (Animal animal : blockEntity.registeredAnimals) {
                int animalDepletionRate = ModConfig.getInstance().getAnimalSettings(animal.getType()).getHungerDepletionRate(baseDepletionRate);
                totalDepletionRate += animalDepletionRate;
                ++animalCount;
            }
            int avgDepletionRate = animalCount > 0 ? totalDepletionRate / animalCount : baseDepletionRate;
            feedingInterval = Math.max(1, avgDepletionRate / 4);
        }
        blockEntity.feedingCooldown = feedingInterval;
    }

    protected void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        this.feedingCooldown = tag.getInt("FeedingCooldown");
        this.registrationCooldown = tag.getInt("RegistrationCooldown");
        this.animalsInRange = tag.getInt("AnimalsInRange");
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        tag.putInt("FeedingCooldown", this.feedingCooldown);
        tag.putInt("RegistrationCooldown", this.registrationCooldown);
        tag.putInt("AnimalsInRange", this.animalsInRange);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.cattlestrophic.feeding_trough");
    }

    public AbstractContainerMenu createMenu(int syncId, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return new FeedingTroughScreenHandler(syncId, playerInventory, this);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack result = ContainerHelper.removeItem(this.inventory, (int)slot, (int)amount);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, @Nonnull ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    private void updateFilledState() {
        BlockState state;
        if (this.level != null && (state = this.level.getBlockState(this.worldPosition)).getBlock() instanceof FeedingTroughBlock) {
            boolean filled = this.hasItems();
            if ((Boolean)state.getValue((Property)FeedingTroughBlock.FILLED) != filled) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)FeedingTroughBlock.FILLED, (Comparable)Boolean.valueOf(filled)), 3);
            }
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.inventory.clear();
        this.setChanged();
    }
}

