/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/cattlestrophic.json");
    private static final String ANIMAL_SETTINGS_DIR = "config/cattlestrophic_animal_settings";
    private static ModConfig INSTANCE;
    private boolean enableMod = true;
    private boolean enableAnimalSettings = false;
    private int hungerDepletionRateInTicks = 6000;
    private int agingRateInTicks = 24000;
    private boolean showHungerIndicators = true;
    private boolean showAgeIndicators = true;
    private int feedingTroughRange = 8;
    private int feedingAmount = 50;
    private int maxAnimalsPerTrough = 8;
    private int breedingCooldownTicks = 6000;
    private int growthTimeTicks = 24000;
    private int wildMaxAge = 100;
    private int domesticatedMaxAge = 150;
    private boolean preventLeashingWildAnimals = true;
    private float wildAnimalBreedChance = 0.5f;
    private int wildBreedingExtraCooldownTicks = 6000;
    private float wildAnimalLootPenaltyMultiplier = 0.5f;
    private float domesticatedAnimalLootBonusMultiplier = 1.5f;
    private Map<String, AnimalSettings> animalSettings = new HashMap<String, AnimalSettings>();

    public static ModConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ModConfig.loadConfig();
        }
        return INSTANCE;
    }

    private static ModConfig loadConfig() {
        boolean isNewConfig;
        ModConfig config = new ModConfig();
        boolean bl = isNewConfig = !CONFIG_FILE.exists();
        if (!isNewConfig) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load config: " + e.getMessage());
                isNewConfig = true;
            }
        }
        config.initDefaultAnimalSettings();
        File animalSettingsDir = new File(ANIMAL_SETTINGS_DIR);
        if (!animalSettingsDir.exists()) {
            animalSettingsDir.mkdirs();
            config.save();
        }
        if (config.getEnableAnimalSettings()) {
            config.loadAnimalSettings();
        }
        return config;
    }

    private void initDefaultAnimalSettings() {
        this.addDefaultAnimalSetting("minecraft:axolotl", new String[]{"minecraft:tropical_fish_bucket"});
        this.addDefaultAnimalSetting("minecraft:camel", new String[]{"minecraft:cactus"});
        this.addDefaultAnimalSetting("minecraft:cat", new String[]{"minecraft:cod", "minecraft:salmon"});
        this.addDefaultAnimalSetting("minecraft:chicken", new String[]{"minecraft:wheat_seeds", "minecraft:melon_seeds", "minecraft:pumpkin_seeds", "minecraft:beetroot_seeds"});
        this.addDefaultAnimalSetting("minecraft:cow", new String[]{"minecraft:wheat"});
        this.addDefaultAnimalSetting("minecraft:donkey", new String[]{"minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:apple", "minecraft:hay_block"});
        this.addDefaultAnimalSetting("minecraft:fox", new String[]{"minecraft:sweet_berries", "minecraft:glow_berries"});
        this.addDefaultAnimalSetting("minecraft:goat", new String[]{"minecraft:wheat"});
        this.addDefaultAnimalSetting("minecraft:horse", new String[]{"minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:apple", "minecraft:hay_block"});
        this.addDefaultAnimalSetting("minecraft:llama", new String[]{"minecraft:hay_block", "minecraft:wheat"});
        this.addDefaultAnimalSetting("minecraft:mule", new String[]{"minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:apple", "minecraft:hay_block"});
        this.addDefaultAnimalSetting("minecraft:ocelot", new String[]{"minecraft:cod", "minecraft:salmon"});
        this.addDefaultAnimalSetting("minecraft:panda", new String[]{"minecraft:bamboo"});
        this.addDefaultAnimalSetting("minecraft:pig", new String[]{"minecraft:carrot", "minecraft:potato", "minecraft:beetroot"});
        this.addDefaultAnimalSetting("minecraft:rabbit", new String[]{"minecraft:carrot", "minecraft:golden_carrot", "minecraft:dandelion"});
        this.addDefaultAnimalSetting("minecraft:sheep", new String[]{"minecraft:wheat"});
        this.addDefaultAnimalSetting("minecraft:turtle", new String[]{"minecraft:seagrass"});
        this.addDefaultAnimalSetting("minecraft:wolf", new String[]{"minecraft:bone"});
        this.addDefaultAnimalSetting("examplemod:example_entity", new String[]{"examplemod:example_item"});
    }

    private void addDefaultAnimalSetting(String entityId, String[] acceptedFoodItems) {
        if (!this.animalSettings.containsKey(entityId)) {
            AnimalSettings settings = new AnimalSettings();
            settings.acceptedFoodItems = acceptedFoodItems;
            this.animalSettings.put(entityId, settings);
        }
    }

    private void loadAnimalSettings() {
        File dir = new File(ANIMAL_SETTINGS_DIR);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        this.animalSettings.clear();
        try {
            File[] namespaceDirs = dir.listFiles(File::isDirectory);
            if (namespaceDirs == null) {
                return;
            }
            for (File namespaceDir : namespaceDirs) {
                String namespace = namespaceDir.getName();
                File[] entityFiles = namespaceDir.listFiles((d, name) -> name.endsWith(".json"));
                if (entityFiles == null) continue;
                for (File entityFile : entityFiles) {
                    try {
                        String entityType = entityFile.getName().replace(".json", "");
                        String entityId = namespace + ":" + entityType;
                        try (FileReader reader = new FileReader(entityFile);){
                            AnimalSettings settings = (AnimalSettings)GSON.fromJson((Reader)reader, AnimalSettings.class);
                            this.animalSettings.put(entityId, settings);
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Failed to load animal settings from " + String.valueOf(entityFile) + ": " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load animal settings: " + e.getMessage());
        }
    }

    private void saveAnimalSettings() {
        File dir = new File(ANIMAL_SETTINGS_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (Map.Entry<String, AnimalSettings> entry : this.animalSettings.entrySet()) {
            this.saveAnimalSetting(entry.getKey(), entry.getValue());
        }
    }

    private void saveAnimalSetting(String entityId, AnimalSettings settings) {
        String[] parts = entityId.split(":", 2);
        if (parts.length != 2) {
            System.err.println("Invalid entity ID format: " + entityId);
            return;
        }
        String namespace = parts[0];
        String entityType = parts[1];
        File namespaceDir = new File("config/cattlestrophic_animal_settings/" + namespace);
        if (!namespaceDir.exists()) {
            namespaceDir.mkdirs();
        }
        File file = new File(namespaceDir, entityType + ".json");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson((Object)settings, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save animal settings for " + entityId + ": " + e.getMessage());
        }
    }

    public void save() {
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
            }
            ModConfig configWithoutAnimalSettings = new ModConfig();
            this.copyConfigExceptAnimalSettings(this, configWithoutAnimalSettings);
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)configWithoutAnimalSettings, (Appendable)writer);
            }
            this.saveAnimalSettings();
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    private void copyConfigExceptAnimalSettings(ModConfig source, ModConfig destination) {
        destination.enableMod = source.enableMod;
        destination.enableAnimalSettings = source.enableAnimalSettings;
        destination.hungerDepletionRateInTicks = source.hungerDepletionRateInTicks;
        destination.agingRateInTicks = source.agingRateInTicks;
        destination.showHungerIndicators = source.showHungerIndicators;
        destination.showAgeIndicators = source.showAgeIndicators;
        destination.feedingTroughRange = source.feedingTroughRange;
        destination.feedingAmount = source.feedingAmount;
        destination.maxAnimalsPerTrough = source.maxAnimalsPerTrough;
        destination.breedingCooldownTicks = source.breedingCooldownTicks;
        destination.growthTimeTicks = source.growthTimeTicks;
        destination.wildMaxAge = source.wildMaxAge;
        destination.domesticatedMaxAge = source.domesticatedMaxAge;
        destination.preventLeashingWildAnimals = source.preventLeashingWildAnimals;
        destination.wildAnimalBreedChance = source.wildAnimalBreedChance;
        destination.wildBreedingExtraCooldownTicks = source.wildBreedingExtraCooldownTicks;
        destination.wildAnimalLootPenaltyMultiplier = source.wildAnimalLootPenaltyMultiplier;
        destination.domesticatedAnimalLootBonusMultiplier = source.domesticatedAnimalLootBonusMultiplier;
    }

    public boolean isModEnabled() {
        return this.enableMod;
    }

    public boolean getEnableAnimalSettings() {
        return this.enableAnimalSettings;
    }

    public boolean shouldPreventLeashingWildAnimals() {
        return this.preventLeashingWildAnimals;
    }

    public int getHungerDepletionRate() {
        return this.hungerDepletionRateInTicks;
    }

    public int getAgingRate() {
        return this.agingRateInTicks;
    }

    public boolean shouldShowHungerIndicators() {
        return this.showHungerIndicators;
    }

    public boolean shouldShowAgeIndicators() {
        return this.showAgeIndicators;
    }

    public int getFeedingTroughRange() {
        return this.feedingTroughRange;
    }

    public int getFeedingAmount() {
        return this.feedingAmount;
    }

    public int getMaxAnimalsPerTrough() {
        return this.maxAnimalsPerTrough;
    }

    public int getBreedingCooldownTicks() {
        return this.breedingCooldownTicks;
    }

    public int getGrowthTimeTicks() {
        return this.growthTimeTicks;
    }

    public int getWildMaxAge() {
        return this.wildMaxAge;
    }

    public int getDomesticatedMaxAge() {
        return this.domesticatedMaxAge;
    }

    public float getWildAnimalBreedChance() {
        return this.wildAnimalBreedChance;
    }

    public int getWildBreedingExtraCooldownTicks() {
        return this.wildBreedingExtraCooldownTicks;
    }

    public float getWildAnimalLootPenaltyMultiplier() {
        return this.wildAnimalLootPenaltyMultiplier;
    }

    public float getDomesticatedAnimalLootBonusMultiplier() {
        return this.domesticatedAnimalLootBonusMultiplier;
    }

    public AnimalSettings getAnimalSettings(EntityType<?> entityType) {
        String key = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString();
        return this.animalSettings.getOrDefault(key, new AnimalSettings());
    }

    public boolean shouldAffectEntity(EntityType<?> entityType) {
        String key = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString();
        return this.animalSettings.containsKey(key);
    }

    public int getBreedingCooldownTicks(EntityType<?> entityType) {
        String key = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString();
        if (this.animalSettings.containsKey(key)) {
            AnimalSettings settings;
            int override;
            if (this.getEnableAnimalSettings() && (override = (settings = this.animalSettings.get(key)).getBreedingCooldownTicks(this.breedingCooldownTicks)) != this.breedingCooldownTicks) {
                return override;
            }
            return this.breedingCooldownTicks;
        }
        return 6000;
    }

    public int getGrowthTimeTicks(EntityType<?> entityType) {
        String key = BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString();
        if (this.animalSettings.containsKey(key)) {
            AnimalSettings settings;
            int override;
            if (this.getEnableAnimalSettings() && (override = (settings = this.animalSettings.get(key)).getGrowthTimeTicks(this.growthTimeTicks)) != this.growthTimeTicks) {
                return override;
            }
            return this.growthTimeTicks;
        }
        return 24000;
    }

    public int getDomesticatedMaxAge(EntityType<?> entityType) {
        AnimalSettings settings = this.getAnimalSettings(entityType);
        if (settings == null) {
            return Integer.MAX_VALUE;
        }
        return settings.getDomesticatedMaxAge(this.domesticatedMaxAge);
    }

    public int getWildMaxAge(EntityType<?> entityType) {
        AnimalSettings settings = this.getAnimalSettings(entityType);
        if (settings == null) {
            return Integer.MAX_VALUE;
        }
        return settings.getWildMaxAge(this.wildMaxAge);
    }

    public static class AnimalSettings {
        private String[] acceptedFoodItems = new String[0];
        private int hungerDepletionRateOverride = -1;
        private int wildMaxAgeOverride = -1;
        private int domesticatedMaxAgeOverride = -1;
        private int breedingCooldownTicksOverride = -1;
        private int growthTimeTicksOverride = -1;
        private int feedingAmountOverride = -1;

        public String[] getAcceptedFoodItems() {
            return this.acceptedFoodItems;
        }

        public int getHungerDepletionRate(int defaultValue) {
            return this.hungerDepletionRateOverride < 0 ? defaultValue : this.hungerDepletionRateOverride;
        }

        public int getWildMaxAge(int defaultValue) {
            return this.wildMaxAgeOverride < 0 ? defaultValue : this.wildMaxAgeOverride;
        }

        public int getDomesticatedMaxAge(int defaultValue) {
            return this.domesticatedMaxAgeOverride < 0 ? defaultValue : this.domesticatedMaxAgeOverride;
        }

        public int getBreedingCooldownTicks(int defaultValue) {
            return this.breedingCooldownTicksOverride < 0 ? defaultValue : this.breedingCooldownTicksOverride;
        }

        public int getGrowthTimeTicks(int defaultValue) {
            return this.growthTimeTicksOverride < 0 ? defaultValue : this.growthTimeTicksOverride;
        }

        public int getFeedingAmount(int defaultValue) {
            return this.feedingAmountOverride < 0 ? defaultValue : this.feedingAmountOverride;
        }
    }
}

