/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.event;

import com.TBF.cattlestrophic.CattlestrophicMod;
import com.TBF.cattlestrophic.capability.AnimalDataCapability;
import com.TBF.cattlestrophic.capability.IAnimalData;
import com.TBF.cattlestrophic.config.ModConfig;
import com.TBF.cattlestrophic.network.SyncAnimalDataS2CPacket;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="cattlestrophic")
public class AnimalEventHandler {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        ModConfig config = ModConfig.getInstance();
        if (!config.isModEnabled()) {
            return;
        }
        if (!config.shouldAffectEntity(animal.getType())) {
            return;
        }
        IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
        if (animalData != null) {
            if (animal.getPersistentData().getInt("CattlestrophicInitialized") != 1) {
                animalData.setHungerLevel(100);
                animalData.setAgeCounter(0);
                animal.getPersistentData().putInt("CattlestrophicInitialized", 1);
                if (!animal.level().isClientSide) {
                    SyncAnimalDataS2CPacket.sendToAll(animal);
                }
            }
        } else {
            CattlestrophicMod.LOGGER.error("Failed to get animal data capability for " + animal.getType().getDescriptionId());
        }
    }

    @SubscribeEvent
    public static void onBabyEntitySpawn(BabyEntitySpawnEvent event) {
        Mob mob;
        int currentAge;
        AgeableMob ageableMob = event.getChild();
        if (!(ageableMob instanceof Animal)) {
            return;
        }
        Animal childAnimal = (Animal)ageableMob;
        ModConfig config = ModConfig.getInstance();
        if (!config.isModEnabled() || !config.shouldAffectEntity(childAnimal.getType())) {
            return;
        }
        IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)childAnimal);
        if (animalData != null) {
            animalData.setDomesticated(true);
            animalData.setHungerLevel(animalData.getMaxHungerLevel());
            childAnimal.getPersistentData().putInt("CattlestrophicInitialized", 1);
            if (!childAnimal.level().isClientSide) {
                SyncAnimalDataS2CPacket.sendToAll(childAnimal);
            }
        }
        if ((currentAge = childAnimal.getAge()) >= 0) {
            return;
        }
        int growthTimeValue = ModConfig.getInstance().getGrowthTimeTicks(childAnimal.getType());
        int finalGrowthTimeTicks = -growthTimeValue;
        childAnimal.setAge(finalGrowthTimeTicks);
        childAnimal.getPersistentData().putBoolean("CattlestrophicCustomGrowth", true);
        if (childAnimal.level().getServer() != null) {
            childAnimal.level().getServer().tell((Runnable)new TickTask(1, () -> {
                if (childAnimal.isAlive() && childAnimal.getAge() != finalGrowthTimeTicks) {
                    childAnimal.setAge(finalGrowthTimeTicks);
                }
            }));
        }
        if ((mob = event.getParentA()) instanceof Animal) {
            Animal parentA = (Animal)mob;
            mob = event.getParentB();
            if (mob instanceof Animal) {
                Animal parentB = (Animal)mob;
                int parentAAge = parentA.getAge();
                int parentBAge = parentB.getAge();
                if (parentAAge > 0) {
                    int parentACooldownTicks = ModConfig.getInstance().getBreedingCooldownTicks(parentA.getType());
                    int finalParentACooldownTicks = Math.max(1, parentACooldownTicks);
                    parentA.setAge(finalParentACooldownTicks);
                    parentA.getPersistentData().putBoolean("CattlestrophicCustomBreeding", true);
                    if (parentA.level().getServer() != null) {
                        parentA.level().getServer().tell((Runnable)new TickTask(1, () -> {
                            if (parentA.isAlive() && parentA.getAge() != finalParentACooldownTicks) {
                                parentA.setAge(finalParentACooldownTicks);
                            }
                        }));
                    }
                }
                if (parentBAge > 0) {
                    int parentBCooldownTicks = ModConfig.getInstance().getBreedingCooldownTicks(parentB.getType());
                    int finalParentBCooldownTicks = Math.max(1, parentBCooldownTicks);
                    parentB.setAge(finalParentBCooldownTicks);
                    parentB.getPersistentData().putBoolean("CattlestrophicCustomBreeding", true);
                    if (parentB.level().getServer() != null) {
                        parentB.level().getServer().tell((Runnable)new TickTask(1, () -> {
                            if (parentB.isAlive() && parentB.getAge() != finalParentBCooldownTicks) {
                                parentB.setAge(finalParentBCooldownTicks);
                            }
                        }));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        if (!ModConfig.getInstance().isModEnabled() || !ModConfig.getInstance().shouldAffectEntity(animal.getType())) {
            return;
        }
        IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
        if (animalData != null) {
            if (animal.level().isClientSide) {
                AnimalEventHandler.handleVisualIndicators(animal, animalData);
                return;
            }
            try {
                if (animalData.isDomesticated()) {
                    int defaultHungerDepletionRate = ModConfig.getInstance().getHungerDepletionRate();
                    int hungerDepletionRate = ModConfig.getInstance().getAnimalSettings(animal.getType()).getHungerDepletionRate(defaultHungerDepletionRate);
                    if (animal.level().getGameTime() % (long)hungerDepletionRate == 0L) {
                        int currentHunger = animalData.getHungerLevel();
                        animalData.setHungerLevel(Math.max(0, currentHunger - 1));
                        if (animal.level().getGameTime() % (long)(hungerDepletionRate * 5) == 0L) {
                            SyncAnimalDataS2CPacket.sendToAll(animal);
                        }
                    }
                    if (animalData.isStarving() && animal.level().getGameTime() % (long)Math.max(1, (int)((double)ModConfig.getInstance().getAnimalSettings(animal.getType()).getHungerDepletionRate(ModConfig.getInstance().getHungerDepletionRate()) * Math.random())) == 0L) {
                        animal.hurt(animal.damageSources().starve(), 1.0f);
                    }
                }
                if (animal.level().getGameTime() % (long)ModConfig.getInstance().getAgingRate() == 0L) {
                    animalData.increaseAge(1);
                    if (animal.level().getGameTime() % (long)(ModConfig.getInstance().getAgingRate() * 5) == 0L) {
                        SyncAnimalDataS2CPacket.sendToAll(animal);
                    }
                }
                if (animalData.hasReachedMaxAge(animal) && animal.level().getGameTime() % (long)Math.max(1, (int)((double)ModConfig.getInstance().getAgingRate() * Math.random())) == 0L) {
                    animal.kill();
                }
            }
            catch (Exception e) {
                CattlestrophicMod.LOGGER.error("Error processing animal update", (Throwable)e);
            }
            AnimalEventHandler.handleVisualIndicators(animal, animalData);
        }
        if (!animal.level().isClientSide && animal.level().getGameTime() % 20L == 0L) {
            if (animal.getAge() < 0 && !animal.getPersistentData().getBoolean("CattlestrophicGrowthTimeApplied")) {
                int defaultGrowthTime = ModConfig.getInstance().getGrowthTimeTicks();
                int growthTime = ModConfig.getInstance().getAnimalSettings(animal.getType()).getGrowthTimeTicks(defaultGrowthTime);
                animal.setAge(-growthTime);
                animal.getPersistentData().putBoolean("CattlestrophicGrowthTimeApplied", true);
            }
            if (animal.getAge() > 0 && !animal.getPersistentData().getBoolean("CattlestrophicBreedingCooldownApplied") && animal.getPersistentData().getInt("CattlestrophicBreedingDelayApplied") != 1) {
                int defaultBreedingCooldown = ModConfig.getInstance().getBreedingCooldownTicks();
                int breedingCooldown = ModConfig.getInstance().getAnimalSettings(animal.getType()).getBreedingCooldownTicks(defaultBreedingCooldown);
                animal.setAge(breedingCooldown);
                animal.getPersistentData().putBoolean("CattlestrophicBreedingCooldownApplied", true);
            }
            if (animal.getAge() == 0) {
                animal.getPersistentData().putBoolean("CattlestrophicBreedingCooldownApplied", false);
                animal.getPersistentData().putInt("CattlestrophicBreedingDelayApplied", 0);
            }
            if (animal.getAge() >= 0) {
                animal.getPersistentData().putBoolean("CattlestrophicGrowthTimeApplied", false);
            }
        }
    }

    private static void handleVisualIndicators(Animal animal, IAnimalData animalData) {
        int hungerLevel;
        boolean isServerSide;
        if (!ModConfig.getInstance().isModEnabled() || !ModConfig.getInstance().shouldAffectEntity(animal.getType())) {
            return;
        }
        if (!animalData.isDomesticated()) {
            return;
        }
        boolean bl = isServerSide = !animal.level().isClientSide;
        if (ModConfig.getInstance().shouldShowHungerIndicators() && animal.level().getGameTime() % (long)Math.max(40, (int)((double)ModConfig.getInstance().getAnimalSettings(animal.getType()).getHungerDepletionRate(ModConfig.getInstance().getHungerDepletionRate()) * Math.random())) == 0L && (hungerLevel = animalData.getHungerLevel()) < 20) {
            Level level;
            if (isServerSide && (level = animal.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, animal.getX(), animal.getY() + (double)animal.getBbHeight() + 0.5, animal.getZ(), 1, 0.1, 0.1, 0.1, 0.01);
            } else if (!isServerSide) {
                animal.level().addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, animal.getX(), animal.getY() + (double)animal.getBbHeight() + 0.5, animal.getZ(), 0.0, 0.0, 0.0);
            }
        }
        if (ModConfig.getInstance().shouldShowAgeIndicators() && animal.level().getGameTime() % (long)Math.max(40, (int)((double)ModConfig.getInstance().getAgingRate() * Math.random())) == 0L) {
            if (animalData.isVeryOld(animal)) {
                if (isServerSide && (var4_7 = animal.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)var4_7;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL, animal.getX(), animal.getY() + (double)animal.getBbHeight() + 0.7, animal.getZ(), 1, 0.1, 0.1, 0.1, 0.01);
                } else if (!isServerSide) {
                    animal.level().addParticle((ParticleOptions)ParticleTypes.SOUL, animal.getX(), animal.getY() + (double)animal.getBbHeight() + 0.7, animal.getZ(), 0.0, 0.0, 0.0);
                }
            } else if (animalData.isOld(animal)) {
                if (isServerSide && (var4_7 = animal.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)var4_7;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.MYCELIUM, animal.getX(), animal.getY() + (double)animal.getBbHeight() + 0.7, animal.getZ(), 1, 0.1, 0.1, 0.1, 0.01);
                } else if (!isServerSide) {
                    animal.level().addParticle((ParticleOptions)ParticleTypes.MYCELIUM, animal.getX(), animal.getY() + (double)animal.getBbHeight() + 0.7, animal.getZ(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLeashAttempt(PlayerInteractEvent.EntityInteract event) {
        IAnimalData animalData;
        if (!ModConfig.getInstance().isModEnabled() || !ModConfig.getInstance().shouldPreventLeashingWildAnimals()) {
            return;
        }
        if (event.getSide() == LogicalSide.CLIENT) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        if (event.getItemStack().getItem() == Items.LEAD && (animalData = AnimalDataCapability.getAnimalData((Entity)animal)) != null && !animalData.isDomesticated()) {
            event.setCanceled(true);
            event.getEntity().displayClientMessage((Component)Component.translatable((String)"message.cattlestrophic.cannot_lead_wild"), true);
        }
    }

    @SubscribeEvent
    public static void onAnimalBreedingAttempt(BabyEntitySpawnEvent event) {
        Animal parentA;
        Mob mob;
        block7: {
            block6: {
                if (!ModConfig.getInstance().isModEnabled()) {
                    return;
                }
                mob = event.getParentA();
                if (!(mob instanceof Animal)) break block6;
                parentA = (Animal)mob;
                mob = event.getParentB();
                if (mob instanceof Animal) break block7;
            }
            return;
        }
        Animal parentB = (Animal)mob;
        IAnimalData parentAData = AnimalDataCapability.getAnimalData((Entity)parentA);
        IAnimalData parentBData = AnimalDataCapability.getAnimalData((Entity)parentB);
        if (parentAData == null || parentBData == null) {
            return;
        }
        double breedingChance = ModConfig.getInstance().getWildAnimalBreedChance();
        if (!(parentAData.isDomesticated() && parentBData.isDomesticated() || !(parentA.getRandom().nextDouble() > breedingChance))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAnimalBreedingCooldown(EntityTickEvent.Post event) {
        if (!ModConfig.getInstance().isModEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        if (animal.level().getGameTime() % 20L != 0L) {
            return;
        }
        if (animal.getAge() <= 0) {
            return;
        }
        IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
        if (animalData != null && !animalData.isDomesticated() && animal.getPersistentData().getInt("CattlestrophicBreedingDelayApplied") != 1) {
            int extraDelay = ModConfig.getInstance().getWildBreedingExtraCooldownTicks();
            int currentAge = animal.getAge();
            animal.setAge(currentAge + extraDelay);
            animal.getPersistentData().putInt("CattlestrophicBreedingDelayApplied", 1);
        }
        if (animal.getAge() == 0) {
            animal.getPersistentData().putInt("CattlestrophicBreedingDelayApplied", 0);
        }
    }
}

