/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.item;

import com.TBF.cattlestrophic.capability.AnimalDataCapability;
import com.TBF.cattlestrophic.capability.IAnimalData;
import com.TBF.cattlestrophic.config.ModConfig;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AnimalFeedItem
extends Item {
    private final int hungerRestoration;

    public AnimalFeedItem(Item.Properties properties, int hungerRestoration) {
        super(properties);
        this.hungerRestoration = hungerRestoration;
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public InteractionResult interactLivingEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        Level world;
        int maxHunger;
        if (player.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!(entity instanceof Animal)) {
            return InteractionResult.PASS;
        }
        Animal animal = (Animal)entity;
        if (!ModConfig.getInstance().shouldAffectEntity(animal.getType())) {
            player.sendSystemMessage((Component)Component.literal((String)"This animal type is not affected by the mod.").withStyle(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
        if (animalData == null) {
            player.sendSystemMessage((Component)Component.literal((String)"No valid animal data found").withStyle(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        if (!animalData.isDomesticated()) {
            player.sendSystemMessage((Component)Component.literal((String)"Only domesticated animals can be fed with this item.").withStyle(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        int currentHunger = animalData.getHungerLevel();
        if (currentHunger >= (maxHunger = animalData.getMaxHungerLevel())) {
            player.sendSystemMessage((Component)Component.literal((String)"This animal is not hungry.").withStyle(ChatFormatting.YELLOW));
            return InteractionResult.FAIL;
        }
        animalData.feed(this.hungerRestoration);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        if ((world = player.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, animal.getX(), animal.getY() + (double)(animal.getBbHeight() / 2.0f), animal.getZ(), 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.playSound(null, animal.getX(), animal.getY(), animal.getZ(), SoundEvents.GENERIC_EAT, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        int newHunger = animalData.getHungerLevel();
        player.sendSystemMessage((Component)Component.literal((String)("Fed animal: " + newHunger + "/" + maxHunger + " hunger")).withStyle(ChatFormatting.GREEN));
        return InteractionResult.SUCCESS;
    }
}

