/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.network;

import com.TBF.cattlestrophic.CattlestrophicMod;
import com.TBF.cattlestrophic.capability.AnimalDataCapability;
import com.TBF.cattlestrophic.capability.IAnimalData;
import com.TBF.cattlestrophic.network.AnimalDataPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.neoforged.neoforge.network.PacketDistributor;

public class SyncAnimalDataS2CPacket {
    public static AnimalDataPacket createPacket(Animal animal) {
        if (animal == null) {
            CattlestrophicMod.LOGGER.error("Cannot create packet for null animal");
            return null;
        }
        IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
        if (animalData == null) {
            CattlestrophicMod.LOGGER.error("Cannot create packet for animal without data capability");
            return null;
        }
        return new AnimalDataPacket(animal.getId(), animalData.isDomesticated(), animalData.getHungerLevel(), animalData.getAgeCounter());
    }

    public static void sendToPlayer(ServerPlayer player, Animal animal) {
        if (player == null || animal == null) {
            return;
        }
        AnimalDataPacket packet = SyncAnimalDataS2CPacket.createPacket(animal);
        if (packet == null) {
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAll(Animal animal) {
        if (animal == null) {
            CattlestrophicMod.LOGGER.warn("Attempted to send sync packet with null animal");
            return;
        }
        if (animal.level().isClientSide) {
            return;
        }
        AnimalDataPacket packet = SyncAnimalDataS2CPacket.createPacket(animal);
        if (packet == null) {
            return;
        }
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

