/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.screen;

import com.TBF.cattlestrophic.screen.ModScreenHandlers;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class FeedingTroughScreenHandler
extends AbstractContainerMenu {
    private final Container container;
    public static final int INVENTORY_SIZE = 54;
    private static final int SLOT_SIZE = 18;
    private static final int FIRST_ROW_Y = 18;
    private static final int PLAYER_INVENTORY_Y = 140;
    private static final int HOTBAR_Y = 198;

    public FeedingTroughScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(54));
    }

    public FeedingTroughScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf data) {
        this(syncId, playerInventory, (Container)new SimpleContainer(54));
    }

    public FeedingTroughScreenHandler(int syncId, Inventory playerInventory, Container container) {
        super((MenuType)ModScreenHandlers.FEEDING_TROUGH_MENU.get(), syncId);
        int col;
        int row;
        FeedingTroughScreenHandler.checkContainerSize((Container)container, (int)54);
        this.container = container;
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot(container, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlot(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 198));
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(@Nonnull Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot != null && slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < 54 ? !this.moveItemStackTo(originalStack, 54, this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, 54, false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }
}

