/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

public class BlockAmountProvider
implements IBlockComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (!config.get(JadeIds.ACCESS_BLOCK_DETAILS)) {
            return;
        }
        BlockState blockState = accessor.getBlockState();
        int amount = -1;
        if (blockState.hasProperty((Property)BlockStateProperties.PICKLES)) {
            amount = (Integer)blockState.getValue((Property)BlockStateProperties.PICKLES);
        } else if (blockState.hasProperty((Property)BlockStateProperties.CANDLES)) {
            amount = (Integer)blockState.getValue((Property)BlockStateProperties.CANDLES);
        } else if (blockState.hasProperty((Property)BlockStateProperties.EGGS)) {
            amount = (Integer)blockState.getValue((Property)BlockStateProperties.EGGS);
        }
        if (amount >= 0) {
            tooltip.add((Component)Component.translatable((String)"jade.access.block.amount", (Object[])new Object[]{amount}));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.BITES)) {
            tooltip.add((Component)Component.translatable((String)"jade.access.block.bites", (Object[])new Object[]{blockState.getValue((Property)BlockStateProperties.BITES)}));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.LAYERS)) {
            tooltip.add((Component)Component.translatable((String)"jade.access.block.layers", (Object[])new Object[]{blockState.getValue((Property)BlockStateProperties.LAYERS)}));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.LEVEL_CAULDRON)) {
            tooltip.add((Component)Component.translatable((String)"jade.access.block.level", (Object[])new Object[]{blockState.getValue((Property)BlockStateProperties.LEVEL_CAULDRON)}));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.ACCESS_BLOCK_AMOUNT;
    }

    @Override
    public boolean isRequired() {
        return true;
    }
}

