/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.api.IJadeProvider;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.lookup.IHierarchyLookup;

public class DumpGenerator {
    public static String generateInfoDump() {
        StringBuilder builder = new StringBuilder("# Jade Handler Dump");
        WailaClientRegistration client = WailaClientRegistration.instance();
        WailaCommonRegistration common = WailaCommonRegistration.instance();
        builder.append("\nGenerated at ").append(ZonedDateTime.now(ZoneOffset.UTC)).append("\n");
        builder.append("\n## Block");
        DumpGenerator.createSection(builder, "Icon Providers", client.blockIconProviders);
        DumpGenerator.createSection(builder, "Component Providers", client.blockComponentProviders);
        DumpGenerator.createSection(builder, "Data Providers", common.blockDataProviders);
        builder.append("\n## Entity");
        DumpGenerator.createSection(builder, "Icon Providers", client.entityIconProviders);
        DumpGenerator.createSection(builder, "Component Providers", client.entityComponentProviders);
        DumpGenerator.createSection(builder, "Data Providers", common.entityDataProviders);
        builder.append("\n## Common Extension");
        DumpGenerator.createSection(builder, "Item Storage", common.itemStorageProviders);
        DumpGenerator.createSection(builder, "Fluid Storage", common.fluidStorageProviders);
        DumpGenerator.createSection(builder, "Energy Storage", common.energyStorageProviders);
        DumpGenerator.createSection(builder, "Progress", common.progressProviders);
        builder.append("\n## Client Extension");
        DumpGenerator.createSection(builder, "Item Storage", client.itemStorageProviders);
        DumpGenerator.createSection(builder, "Fluid Storage", client.fluidStorageProviders);
        DumpGenerator.createSection(builder, "Energy Storage", client.energyStorageProviders);
        DumpGenerator.createSection(builder, "Progress", client.progressProviders);
        builder.append("\n## Priorities");
        for (ResourceLocation resourceLocation : common.priorities.getSortedList()) {
            builder.append("\n* ").append(resourceLocation);
        }
        return builder.toString();
    }

    private static void createSection(StringBuilder builder, String subsection, Map<ResourceLocation, ? extends IJadeProvider> map) {
        if (map.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        map.forEach((key, value) -> {
            builder.append("\n\n#### ").append(key);
            builder.append("\n* ").append(value.getUid()).append(", ").append(value.getClass().getName());
        });
        builder.append("\n\n");
    }

    private static void createSection(StringBuilder builder, String subsection, IHierarchyLookup<? extends IJadeProvider> lookup) {
        if (lookup.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        lookup.entries().forEach(entry -> {
            builder.append("\n\n#### ").append(((Class)entry.getKey()).getName());
            ((Collection)entry.getValue()).stream().distinct().sorted(Comparator.comparingInt(WailaCommonRegistration.instance().priorities::byValue)).forEach($ -> builder.append("\n* ").append($.getUid()).append(", ").append(WailaCommonRegistration.instance().priorities.byValue((IJadeProvider)$)).append(", ").append($.getClass().getName()));
        });
        builder.append("\n\n");
    }
}

