/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum;

import com.google.common.base.Preconditions;
import dev.obscuria.fragmentum.Fragmentum;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class FragmentumProxy {
    @Nullable
    private static MinecraftServer server = null;

    public static MinecraftServer server() {
        return Objects.requireNonNull(server);
    }

    public static Optional<MinecraftServer> optionalServer() {
        return Optional.ofNullable(server);
    }

    public static RegistryAccess registryAccess() {
        if (server != null) {
            return server.registryAccess();
        }
        Preconditions.checkState((boolean)Fragmentum.PLATFORM.isClient(), (Object)"Can't reach server RegistryAccess");
        IntegratedServer integratedServer = Minecraft.getInstance().getSingleplayerServer();
        if (integratedServer != null) {
            return integratedServer.registryAccess();
        }
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        Preconditions.checkNotNull((Object)connection, (Object)"Can't reach client RegistryAccess");
        return connection.registryAccess();
    }

    public static void onServerStart(MinecraftServer server) {
        FragmentumProxy.server = server;
    }

    public static void onServerStop(MinecraftServer server) {
        FragmentumProxy.server = null;
    }
}

