/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.config;

import dev.obscuria.fragmentum.Fragmentum;
import dev.obscuria.fragmentum.config.ConfigValue;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public final class ConfigBuilder {
    public final ModConfigSpec.Builder specBuilder = new ModConfigSpec.Builder();
    @Nullable
    public final String fileName;

    public ConfigBuilder() {
        this.fileName = null;
    }

    public ConfigBuilder(String fileName) {
        this.fileName = fileName;
    }

    public ConfigBuilder comment(String comment) {
        this.specBuilder.comment(comment);
        return this;
    }

    public ConfigBuilder comment(String ... comment) {
        this.specBuilder.comment(comment);
        return this;
    }

    public void push(String name) {
        this.specBuilder.push(name);
    }

    public void pop() {
        this.specBuilder.pop();
    }

    public <T> ConfigValue<T> define(String path, T defaultValue) {
        return new ConfigValue(this.specBuilder.define(path, defaultValue));
    }

    public ConfigValue<Boolean> defineBoolean(String path, boolean defaultValue) {
        return new ConfigValue<Boolean>((ModConfigSpec.ConfigValue<Boolean>)this.specBuilder.define(path, defaultValue));
    }

    public ConfigValue<Integer> defineInt(String path, int defaultValue, int min, int max) {
        return new ConfigValue<Integer>((ModConfigSpec.ConfigValue<Integer>)this.specBuilder.defineInRange(path, defaultValue, min, max));
    }

    public ConfigValue<Double> defineDouble(String path, double defaultValue, double min, double max) {
        return new ConfigValue<Double>((ModConfigSpec.ConfigValue<Double>)this.specBuilder.defineInRange(path, defaultValue, min, max));
    }

    public ConfigValue<String> defineString(String path, String defaultValue) {
        return new ConfigValue<String>(this.specBuilder.define(path, (Object)defaultValue));
    }

    public <T extends Enum<T>> ConfigValue<T> DefineEnum(String path, T defaultValue) {
        return new ConfigValue(this.specBuilder.defineEnum(path, defaultValue));
    }

    public <T> ConfigValue<List<? extends T>> defineList(String path, List<T> defaultValue, Supplier<T> newElementSupplier) {
        return this.defineList(path, defaultValue, newElementSupplier, it -> true);
    }

    public <T> ConfigValue<List<? extends T>> defineList(String path, List<T> defaultValue, Supplier<T> newElementSupplier, Predicate<Object> predicate) {
        return new ConfigValue<List<? extends T>>(this.specBuilder.defineListAllowEmpty(path, defaultValue, newElementSupplier, predicate));
    }

    public void buildClient(String modId) {
        Fragmentum.SERVICES.config().registerClient(modId, this);
    }

    public void buildCommon(String modId) {
        Fragmentum.SERVICES.config().registerCommon(modId, this);
    }

    public void buildServer(String modId) {
        Fragmentum.SERVICES.config().registerServer(modId, this);
    }
}

