/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.content.script.types;

import dev.obscuria.fragmentum.content.script.types.LuaOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaUserdata;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public abstract class LuaWrapper<T>
extends LuaUserdata {
    public final T source;
    private final LuaOps<T> ops;

    public LuaWrapper(T source, LuaOps<T> ops) {
        super(source);
        this.source = source;
        this.ops = ops;
        Builder builder = new Builder();
        this.build(builder);
        builder.build();
    }

    protected abstract void build(Builder var1);

    protected <R> LibFunction method0(final LuaOps<R> result, final Method0<T, R> method) {
        return new OneArgFunction(){

            public LuaValue call(LuaValue self) {
                return result.wrap(method.invoke(LuaWrapper.this.ops.unwrap(self)));
            }
        };
    }

    protected <A, R> LibFunction method1(final LuaOps<A> argA, final LuaOps<R> result, final Method1<T, A, R> method) {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue self, LuaValue a) {
                return result.wrap(method.invoke(LuaWrapper.this.ops.unwrap(self), argA.unwrap(a)));
            }
        };
    }

    protected <A, B, R> LibFunction method2(final LuaOps<A> argA, final LuaOps<B> argB, final LuaOps<R> result, final Method2<T, A, B, R> method) {
        return new ThreeArgFunction(){

            public LuaValue call(LuaValue self, LuaValue a, LuaValue b) {
                return result.wrap(method.invoke(LuaWrapper.this.ops.unwrap(self), argA.unwrap(a), argB.unwrap(b)));
            }
        };
    }

    protected <A, B, C, R> LibFunction method3(final LuaOps<A> argA, final LuaOps<B> argB, final LuaOps<C> argC, final LuaOps<R> result, final Method3<T, A, B, C, R> method) {
        return new VarArgFunction(){

            public Varargs invoke(Varargs args) {
                return result.wrap(method.invoke(LuaWrapper.this.ops.unwrap(args.arg(1)), argA.unwrap(args.arg(2)), argB.unwrap(args.arg(3)), argC.unwrap(args.arg(4))));
            }
        };
    }

    protected <R> LibFunction nilMethod0(final LuaOps.Nilable<R> result, final NilMethod0<T, R> method) {
        return new OneArgFunction(){

            public LuaValue call(LuaValue self) {
                return result.wrap(method.invoke(LuaWrapper.this.ops.unwrap(self)));
            }
        };
    }

    protected <A, R> LibFunction nilMethod1(final LuaOps<A> argA, final LuaOps.Nilable<R> result, final NilMethod1<T, A, R> method) {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue self, LuaValue a) {
                return result.wrap(method.invoke(LuaWrapper.this.ops.unwrap(self), argA.unwrap(a)));
            }
        };
    }

    protected <A, B, R> LibFunction nilMethod2(final LuaOps<A> argA, final LuaOps<B> argB, final LuaOps.Nilable<R> result, final NilMethod2<T, A, B, R> method) {
        return new ThreeArgFunction(){

            public LuaValue call(LuaValue self, LuaValue a, LuaValue b) {
                return result.wrap(method.invoke(LuaWrapper.this.ops.unwrap(self), argA.unwrap(a), argB.unwrap(b)));
            }
        };
    }

    protected <A, B, C, R> LibFunction nilMethod3(final LuaOps<A> argA, final LuaOps<B> argB, final LuaOps<C> argC, final LuaOps.Nilable<R> result, final NilMethod3<T, A, B, C, R> method) {
        return new VarArgFunction(){

            public Varargs invoke(Varargs args) {
                return result.wrap(method.invoke(LuaWrapper.this.ops.unwrap(args.arg(1)), argA.unwrap(args.arg(2)), argB.unwrap(args.arg(3)), argC.unwrap(args.arg(4))));
            }
        };
    }

    protected LibFunction voidMethod0(final VoidMethod0<T> method) {
        return new OneArgFunction(){

            public LuaValue call(LuaValue self) {
                method.invoke(LuaWrapper.this.ops.unwrap(self));
                return NIL;
            }
        };
    }

    protected <A> LibFunction voidMethod1(final LuaOps<A> argA, final VoidMethod1<T, A> method) {
        return new TwoArgFunction(){

            public LuaValue call(LuaValue self, LuaValue a) {
                method.invoke(LuaWrapper.this.ops.unwrap(self), argA.unwrap(a));
                return NIL;
            }
        };
    }

    protected <A, B> LibFunction voidMethod2(final LuaOps<A> argA, final LuaOps<B> argB, final VoidMethod2<T, A, B> method) {
        return new ThreeArgFunction(){

            public LuaValue call(LuaValue self, LuaValue a, LuaValue b) {
                method.invoke(LuaWrapper.this.ops.unwrap(self), argA.unwrap(a), argB.unwrap(b));
                return NIL;
            }
        };
    }

    protected <A, B, C> LibFunction voidMethod3(final LuaOps<A> argA, final LuaOps<B> argB, final LuaOps<C> argC, final VoidMethod3<T, A, B, C> method) {
        return new VarArgFunction(){

            public Varargs invoke(Varargs args) {
                method.invoke(LuaWrapper.this.ops.unwrap(args.arg(1)), argA.unwrap(args.arg(2)), argB.unwrap(args.arg(3)), argC.unwrap(args.arg(4)));
                return NIL;
            }
        };
    }

    @Generated
    public T getSource() {
        return this.source;
    }

    public class Builder {
        private final Map<String, Property<T, ?>> properties = new HashMap();
        private final Map<String, LibFunction> methods = new HashMap<String, LibFunction>();

        public <V> void put(String name, Property<T, V> property) {
            this.properties.put(name, property);
        }

        public void put(String name, LibFunction method) {
            this.methods.put(name, method);
        }

        private void build() {
            LuaTable meta = new LuaTable();
            meta.set("__index", (LuaValue)new TwoArgFunction(){

                public LuaValue call(LuaValue userdata, LuaValue key) {
                    String name = key.checkjstring();
                    LibFunction method = Builder.this.methods.get(name);
                    if (method != null) {
                        return method;
                    }
                    Property property = Builder.this.properties.get(name);
                    if (property != null) {
                        return property.get(LuaWrapper.this.source);
                    }
                    return NIL;
                }
            });
            meta.set("__newindex", (LuaValue)new ThreeArgFunction(){

                public LuaValue call(LuaValue userdata, LuaValue key, LuaValue value) {
                    String name = key.checkjstring();
                    Property property = Builder.this.properties.get(name);
                    if (property != null) {
                        property.set(LuaWrapper.this.source, value);
                    }
                    return NIL;
                }
            });
            LuaWrapper.this.setmetatable((LuaValue)meta);
        }
    }

    @FunctionalInterface
    public static interface Method0<S, R> {
        public R invoke(S var1);
    }

    @FunctionalInterface
    public static interface Method1<S, A, R> {
        public R invoke(S var1, A var2);
    }

    @FunctionalInterface
    public static interface Method2<S, A, B, R> {
        public R invoke(S var1, A var2, B var3);
    }

    @FunctionalInterface
    public static interface Method3<S, A, B, C, R> {
        public R invoke(S var1, A var2, B var3, C var4);
    }

    @FunctionalInterface
    public static interface NilMethod0<S, R> {
        @Nullable
        public R invoke(S var1);
    }

    @FunctionalInterface
    public static interface NilMethod1<S, A, R> {
        @Nullable
        public R invoke(S var1, A var2);
    }

    @FunctionalInterface
    public static interface NilMethod2<S, A, B, R> {
        @Nullable
        public R invoke(S var1, A var2, B var3);
    }

    @FunctionalInterface
    public static interface NilMethod3<S, A, B, C, R> {
        @Nullable
        public R invoke(S var1, A var2, B var3, C var4);
    }

    @FunctionalInterface
    public static interface VoidMethod0<S> {
        public void invoke(S var1);
    }

    @FunctionalInterface
    public static interface VoidMethod1<S, A> {
        public void invoke(S var1, A var2);
    }

    @FunctionalInterface
    public static interface VoidMethod2<S, A, B> {
        public void invoke(S var1, A var2, B var3);
    }

    @FunctionalInterface
    public static interface VoidMethod3<S, A, B, C> {
        public void invoke(S var1, A var2, B var3, C var4);
    }

    public record Property<T, V>(LuaOps<V> ops, @Nullable Function<T, V> getter, @Nullable BiConsumer<T, V> setter) {
        public static <T, V> Property<T, V> of(LuaOps<V> ops, Function<T, V> getter, BiConsumer<T, V> setter) {
            return new Property<T, V>(ops, getter, setter);
        }

        public static <T, V> Property<T, V> readOnly(LuaOps<V> ops, Function<T, V> getter) {
            return new Property<T, V>(ops, getter, null);
        }

        public static <T, V> Property<T, V> writeOnly(LuaOps<V> ops, BiConsumer<T, V> setter) {
            return new Property<T, V>(ops, null, setter);
        }

        public LuaValue get(T source) {
            if (this.getter == null) {
                return LuaValue.NIL;
            }
            return this.ops.wrap(this.getter.apply(source));
        }

        public void set(T source, LuaValue luaValue) {
            if (this.setter == null) {
                return;
            }
            this.setter.accept(source, this.ops.unwrap(luaValue));
        }
    }

    @FunctionalInterface
    public static interface QuadConsumer<A, B, C, D> {
        public void accept(A var1, B var2, C var3, D var4);
    }
}

