/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.fragmentum.neoforge.registry;

import com.mojang.serialization.Codec;
import dev.obscuria.fragmentum.content.registry.Deferred;
import dev.obscuria.fragmentum.content.registry.DeferredAttribute;
import dev.obscuria.fragmentum.content.registry.DeferredBlock;
import dev.obscuria.fragmentum.content.registry.DeferredBlockEntity;
import dev.obscuria.fragmentum.content.registry.DeferredEntity;
import dev.obscuria.fragmentum.content.registry.DeferredItem;
import dev.obscuria.fragmentum.content.registry.DeferredMobEffect;
import dev.obscuria.fragmentum.content.registry.DeferredParticle;
import dev.obscuria.fragmentum.content.registry.DelegatedRegistry;
import dev.obscuria.fragmentum.content.registry.Registrar;
import dev.obscuria.fragmentum.neoforge.NeoFragmentum;
import dev.obscuria.fragmentum.neoforge.registry.NeoDelegatedRegistry;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;

public record NeoRegistrar(String modId) implements Registrar
{
    @Override
    public <T, V extends T> Deferred<T, V> register(Registry<T> registry, ResourceLocation id, Supplier<V> supplier) {
        return this.register(registry.key(), id, supplier);
    }

    @Override
    public <T, V extends T> Deferred<T, V> register(ResourceKey<? extends Registry<T>> registryKey, ResourceLocation id, Supplier<V> supplier) {
        return new Deferred(this.registerInternal(registryKey, id, supplier));
    }

    @Override
    public <T extends Item> DeferredItem<T> registerItem(ResourceLocation id, Supplier<T> supplier) {
        return new DeferredItem((Supplier<Holder<Item>>)this.registerInternal(Registries.ITEM, id, supplier));
    }

    @Override
    public <T extends Block> DeferredBlock<T> registerBlock(ResourceLocation id, Supplier<T> supplier) {
        return new DeferredBlock((Supplier<Holder<Block>>)this.registerInternal(Registries.BLOCK, id, supplier));
    }

    @Override
    public <T extends Entity> DeferredEntity<T> registerEntity(ResourceLocation id, Supplier<EntityType<T>> supplier) {
        return new DeferredEntity((Supplier<Holder<EntityType<?>>>)this.registerInternal(Registries.ENTITY_TYPE, id, supplier));
    }

    @Override
    public <T extends BlockEntity> DeferredBlockEntity<T> registerBlockEntity(ResourceLocation id, Supplier<BlockEntityType<T>> supplier) {
        return new DeferredBlockEntity((Supplier<Holder<BlockEntityType<?>>>)this.registerInternal(Registries.BLOCK_ENTITY_TYPE, id, supplier));
    }

    @Override
    public <T extends MobEffect> DeferredMobEffect<T> registerMobEffect(ResourceLocation id, Supplier<MobEffect> supplier) {
        return new DeferredMobEffect((Supplier<Holder<MobEffect>>)this.registerInternal(Registries.MOB_EFFECT, id, supplier));
    }

    @Override
    public <T extends ParticleOptions> DeferredParticle<T> registerParticle(ResourceLocation id, Supplier<ParticleType<T>> supplier) {
        return new DeferredParticle((Supplier<Holder<ParticleType<?>>>)this.registerInternal(Registries.PARTICLE_TYPE, id, supplier));
    }

    @Override
    public DeferredAttribute registerAttribute(ResourceLocation id, Supplier<Attribute> supplier) {
        return new DeferredAttribute((Supplier<Holder<Attribute>>)this.registerInternal(Registries.ATTRIBUTE, id, supplier));
    }

    @Override
    public <T> DelegatedRegistry<T> createRegistry(ResourceKey<Registry<T>> registryKey) {
        Registry registry = new RegistryBuilder(registryKey).create();
        NeoFragmentum.addListener(this.modId, event -> event.register(registry));
        return new NeoDelegatedRegistry(registry);
    }

    @Override
    public <T> void createDataRegistry(ResourceKey<Registry<T>> registryKey, Supplier<Codec<T>> codec) {
        NeoFragmentum.addListener(this.modId, event -> event.dataPackRegistry(registryKey, (Codec)codec.get()));
    }

    @Override
    public <T> void createSyncedDataRegistry(ResourceKey<Registry<T>> registryKey, Supplier<Codec<T>> codec) {
        NeoFragmentum.addListener(this.modId, event -> event.dataPackRegistry(registryKey, (Codec)codec.get(), (Codec)codec.get()));
    }

    @Override
    public <T> void createSyncedDataRegistry(ResourceKey<Registry<T>> registryKey, Supplier<Codec<T>> codec, Supplier<Codec<T>> networkCodec) {
        NeoFragmentum.addListener(this.modId, event -> event.dataPackRegistry(registryKey, (Codec)codec.get(), (Codec)networkCodec.get()));
    }

    @Override
    public void registerAttributes(DeferredEntity<? extends LivingEntity> entity, AttributeSupplier.Builder builder) {
        NeoFragmentum.addListener(this.modId, event -> event.put((EntityType)entity.get(), builder.build()));
    }

    private <T> Lazy<Holder<T>> registerInternal(ResourceKey<? extends Registry<T>> key, ResourceLocation id, Supplier<? extends T> supplier) {
        DeferredRegister deferredRegister = DeferredRegister.create(key, (String)this.modId);
        NeoFragmentum.register(this.modId, deferredRegister);
        DeferredHolder object = deferredRegister.register(id.getPath(), supplier);
        return Lazy.of(() -> object);
    }
}

